<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Oscar Pohl <opohl@i-doit.de>
 * @version    1.12.2
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\SyncModifier;
use isys_cmdb_dao_category_s_net;

/**
 * Class NetProcessor
 *
 * @package idoit\Module\Api\Model\Cmdb\Category\Processor
 */
class NetProcessor extends AbstractCategoryProcessor implements SyncModifier
{
    /**
     * @var isys_cmdb_dao_category_s_net
     */
    protected $dao;

    /**
     * @param array $syncData
     *
     * @return array
     */
    public function modifySyncData(array $syncData)
    {
        $objectID = $this->request['object'];
        $layer2assignments = $syncData['properties']['layer2_assignments']['value'];

        // @see  API-276  prevent object from assigning itself
        if ($layer2assignments == $objectID) {
            $layer2assignments = $this->dao->get_assigned_layer_2_ids($objectID, true);
        } elseif (is_array($layer2assignments) && ($key = array_search($objectID, $layer2assignments)) !== false) {
            unset($layer2assignments[$key]);
            if (empty($layer2assignments)) {
                $layer2assignments = $this->dao->get_assigned_layer_2_ids($objectID, true);
            }
        }
        $syncData['properties']['layer2_assignments']['value'] = $layer2assignments;
        return $syncData;
    }
}
