<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Response;

/**
 * Class RpcResponse
 *
 * @package idoit\Module\Api\Response
 */
class RpcResponse extends AbstractResponse
{

    /**
     * Identifier
     *
     * @var int
     */
    protected $id;

    /**
     * Result
     *
     * @var array
     */
    protected $result;

    /**
     * Version
     *
     * @var string
     */
    protected $version;

    /**
     * Get response id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set response id
     *
     * @param int $id
     *
     * @return RpcResponse
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get response version
     *
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }

    /**
     * Set response version
     *
     * @param string $version
     *
     * @return RpcResponse
     */
    public function setVersion($version)
    {
        $this->version = $version;

        return $this;
    }

    /**
     * Get response result
     *
     * @return array
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * Set response result
     *
     * @param array $result
     *
     * @return RpcResponse
     */
    public function setResult(array $result = null)
    {
        $this->result = $result;

        return $this;
    }

    public function getResponse()
    {
        return [
            'id'      => $this->getId(),
            'jsonrpc' => $this->getVersion(),
            'result'  => $this->getResult()
        ];
    }

    /**
     * Validate response
     *
     * @return bool
     */
    public function validate()
    {
        return $this->getResult() === null || is_array($this->getResult());
    }

    /**
     * RpcResponse constructor.
     *
     * @param int    $id
     * @param string $version
     * @param array  $result
     */
    public function __construct($id, $version, $result)
    {
        $this->setId($id)
            ->setVersion($version)
            ->setResult($result);
    }
}