# i-doit pull requests

## Requirements

 - Pull requests which combine multiple pull request needs to have a **Milestone** prefix
 - Pull requests which are not finished yet needs to have a **W.I.P.** prefix or shouldn't exist
 - No changes are allowed to be committed directly
 - Pull requests are not allowed to become older than **2 weeks**
 - All pull requests have to be approved by two reviewers
 - The source branch in the pull request needs to be build successfully by our CI

## Creator Workflow

 1. Create a branch for your feature/bug/hotfix
 2. git checkout origin branch for fixVersion of ticket
 e.g. **git checkout develop**
 3. Get latest changes for branch by **git fetch && git pull**
 4. git checkout -b branchType/ticketId_description
 e.g. **git checkout -b feature/API-007_fix-create-object-bug**
 5. Applying changes either via PHPStorm or Console
	 The commit message has to be descriptive.
	 Please do not use the `-n` flag.
6. Push your changes with **git push**
7. On first push bitbucket will tell you to create a upstream branch like this:
	**git push --set-upstream origin branchName**
8. As result on push bitbucket will provide a pull request link, open it to create a new pull request for the given branch.
9. Choose reviewers based on your branch type, e.g. your personal reviewer and one specific reviewer for features.
10. Provide a description what this pull request does.
11. Ensure that the pull request meets all requirements
12. Be sure that source branch is synchronized with the target branch

## Reviewer Workflow

 1. Find your reviewing pull requests here: https://bitbucket.org/dashboard/pullrequests
 2. Comment your concerns on the respective line and create a task if necessary 
 3. When all tasks are resolved approve the pull request for merge
 4. Whenever a commit after the review happens, remove approval and repeat 1 - 3.