<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Oscar Pohl <opohl@i-doit.com>
 * @version    1.15
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Dialog\DialogPlusAdmin;
use idoit\Module\Api\Exception\JsonRpc\ParameterException;
use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\RequestModifier;
use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\SyncModifier;

/**
 * Class ModelProcessor
 *
 * @package idoit\Module\Api\Model\Cmdb\Category\Processor
 */
class ApplicationAssignedObjProcessor extends AbstractCategoryProcessor implements SyncModifier, RequestModifier
{

    /**
     * Raw request
     *
     * @var array
     */
    protected $rawRequest = [];

    /**
     * Modify api request
     *
     * @param array $request
     *
     * @return array
     */
    public function modifyRequest(array $request)
    {
        // Check whether request wants to create some data and application is set
        if ($request['option'] === 'create' && isset($request['data']['assigned_database_schema'])) {

            // Create application  dao
            $dao = new \isys_cmdb_dao_category_s_application_assigned_obj(\isys_application::instance()->container->get('database'));

            // Create application  assignment
            $entryId = $dao->create($request['objID'], C__RECORD_STATUS__NORMAL, $request['data']['object'], '');

            // Transform request into an update
            $request['option'] = 'update';
            $request['id'] = $entryId;
            $request['data']['id'] = $entryId;
        }

        $this->rawRequest = $request;

        return $request;
    }

    /**
     * Modify sync data
     *
     * @param array $syncData
     *
     * @return array
     */
    public function modifySyncData(array $syncData)
    {
        /**
         * Check whether assigned database schema was setted explicitly by request
         * or was added by isys_api_model_cmdb_category::__to_sync_structure().
         *
         * In last cas we will remove it because the key will simply hold the
         * isys_catg_relation__id but sync will interpret it as object id.
         */
        if (is_array($this->rawRequest['data']) && !array_key_exists('assigned_database_schema', $this->rawRequest['data'])) {
            $syncData['properties']['assigned_database_schema'] = null;
        }
        if (is_array($this->rawRequest['data']) && !array_key_exists('assigned_it_service', $this->rawRequest['data'])) {
            $syncData['properties']['assigned_it_service'] = null;
        }

        return $syncData;
    }
}
