<?php

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\ResponseModifier;
use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\SyncModifier;
use isys_cmdb_dao_category_s_chassis as CategoryChassis;

/**
 * ChassisDeviceProcessor
 *
 * @package    idoit\Module\Api\Model\Category
 * @author     Leonard Fischer <lfischer@i-doit.com>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class ChassisDeviceProcessor extends AbstractCategoryProcessor implements SyncModifier, ResponseModifier
{
    /**
     * Modify sync data
     *
     * @param array $syncData
     *
     * @return array
     */
    public function modifySyncData(array $syncData)
    {
        /**
         * @see  API-178  Preparing the necessary structure for assigned slots.
         */
        if (isset($syncData['properties']['assigned_slots']['value']) && is_array($syncData['properties']['assigned_slots']['value'])) {
            foreach ($syncData['properties']['assigned_slots']['value'] as &$value) {
                $value = ['id' => $value];
            }
        }

        return $syncData;
    }

    /**
     * Modify api response
     *
     * @param array $response
     *
     * @return array
     */
    public function modifyResponse(array $response)
    {
        // @see  API-178  Fill up the "assigned_slots" property, if we read data.
        if ($this->getRequest()['option'] === 'read' && is_array($response) && $this->getDao() instanceof CategoryChassis) {
            foreach ($response as &$entry) {
                if (!empty($entry['assigned_slots'])) {
                    continue;
                }

                $result = $this->getDao()->get_assigned_slots_by_cat_id($entry['id']);

                if (is_countable($result) && \count($result)) {
                    $entry['assigned_slots'] = [];

                    foreach ($result as $item) {
                        $entry['assigned_slots'][] = [
                            'id'    => (int)$item['isys_cats_chassis_slot_list__id'],
                            'type'  => 'C__CATS__CHASSIS_SLOT',
                            'title' => $item['isys_cats_chassis_slot_list__title']
                        ];
                    }
                }
            }
        }

        return $response;
    }
}
