<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Denis Koroliov <dk@mobilunity.com>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Dialog\AdminBuilder;
use idoit\Module\Api\Dialog\DialogPlusAdmin;
use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\RequestModifier;
use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\SyncModifier;
use isys_exception_api_validation;
use isys_request;

/**
 * IpAddressesProcessor
 *
 * @see        API-265  In order to provide the correct data structure, we implemented this processor.
 * @package    idoit\Module\Api\Model\Category
 */
class Layer2NetAssignProcessor extends AbstractCategoryProcessor implements SyncModifier
{
    /**
     * @param array $syncData
     *
     * @return array
     * @throws \isys_exception_database
     */
    public function modifySyncData(array $syncData)
    {
        // Get request information.
        $request = $this->getRequest();
        $generalDao = $this->getDao();

        // Skip non-save requests.
        if (!in_array($request['option'], ['save', 'update'], true)) {
            return $syncData;
        }


        // @see  API-224  We need to deal with possible wrong references, due to property field definition.
        if ((!isset($syncData['properties']['tag']['value']) || !is_array($syncData['properties']['tag']['value'])) && $generalDao instanceof \isys_cmdb_dao_category_g_global) {
            // Read the tags of the given object.
            $assignedTagIds = $generalDao->get_assigned_tag($request['object'], true);

            if (count($assignedTagIds) === 0) {
                return $syncData;
            }

            // Re-set the tag IDs.
            $syncData['properties']['tag']['value'] = array_map('intval', $assignedTagIds);

        }
        if(isset($syncData['properties']['isys_catg_port_list__id']['value'])) {
            $syncData['properties']['isys_catg_port_list__id']['ref_id'] = $syncData['properties']['isys_catg_port_list__id']['value'];
        }

        return $syncData;
    }
}
