<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.com>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Property;

/**
 * Class PropertyWriteEntityDefinition
 *
 * @package idoit\Module\Api\Property
 */
class PropertyWriteEntityDefinition
{
    public static function get($propertyDefinition)
    {
        $propertyEntity = new PropertyWriteEntity('Unknown Property', null);

        switch ($propertyDefinition[C__PROPERTY__INFO][C__PROPERTY__INFO__TYPE]) {
            case C__PROPERTY__INFO__TYPE__DATE:
                $propertyEntity = new PropertyWriteEntity('Date', '2018-01-01');
                $propertyEntity->addDefinition('string', 'ISO-XXXX formated date as string', '2018-01-01');
                break;
            case C__PROPERTY__INFO__TYPE__DATETIME:
                $propertyEntity = new PropertyWriteEntity('Date', '2018-01-01 12:00:00');
                $propertyEntity->addDefinition('string', 'ISO-XXXX formated date time as string', '2018-01-01 12:00:00');
                break;
            case C__PROPERTY__INFO__TYPE__DIALOG:
                $propertyEntity = new PropertyWriteEntity('Dialog', 'Example Dialog title');
                $propertyEntity->addDefinition('integer', 'Id referencing an existing dialog entry.', 1)
                    ->addDefinition('string', 'String value that reference an existing dialog entry by its title or constant.', 'Dialog title #1');
                break;
            case C__PROPERTY__INFO__TYPE__DIALOG_PLUS:
                $propertyEntity = new PropertyWriteEntity('Dialog Plus', 'Example Dialog Plus title');
                $propertyEntity->addDefinition('integer', 'Id referencing an existing dialog plus entry.', 1)
                    ->addDefinition('string', 'String value that reference an existing dialog entry by its title or constant. Otherwise a new entry will be created.',
                        'Dialog title #1');
                break;
            case C__PROPERTY__INFO__TYPE__DIALOG_LIST:
                $propertyEntity = new PropertyWriteEntity('Dialog List', ['List entry #1', 'List entry #2', 'List entry #3']);
                $propertyEntity->addDefinition('integer[]', 'Array of ids referencing existing dialog entries.', [3, 4, 5])
                    ->addDefinition('string', 'Array of strings referencing existing dialog entries by title or constant. Unknown strings will result in new dialog entries.',
                        ['List entry #1', 'List entry #2', 'List entry #3']);
                break;
            case C__PROPERTY__INFO__TYPE__DOUBLE:
                $propertyEntity = new PropertyWriteEntity('Double', 20000);
                $propertyEntity->addDefinition('integer', 'A valid integer value', 20)
                    ->addDefinition('double', 'A valid double value.', 200.00);
                break;
            case C__PROPERTY__INFO__TYPE__FLOAT:
                $propertyEntity = new PropertyWriteEntity('Float', 100.00);
                $propertyEntity->addDefinition('integer', 'A valid integer value', 10)
                    ->addDefinition('float', 'A valid float value.', 100.00);
                break;

            case C__PROPERTY__INFO__TYPE__INT:
                $propertyEntity = new PropertyWriteEntity('Integer', 10);
                $propertyEntity->addDefinition('integer', 'A valid integer value', 10);
                break;
            case C__PROPERTY__INFO__TYPE__MONEY:
                $propertyEntity = new PropertyWriteEntity('Money', 5000.00);
                $propertyEntity->addDefinition('integer', 'A valid integer value', 10)
                    ->addDefinition('float', 'A valid float value.', 100.00);
                break;
            case C__PROPERTY__INFO__TYPE__MULTISELECT:
                $propertyEntity = new PropertyWriteEntity('Multi Select', ['List entry #1', 'List entry #2', 'List entry #3']);
                $propertyEntity->addDefinition('integer[]', 'Array of ids referencing existing dialog entries.', [1, 2, 3])
                    ->addDefinition('string', 'Array of strings referencing existing dialog entries by title or constant. Unknown strings will result in new dialog entries.',
                        ['List entry #1', 'List entry #2', 'List entry #3']);
                break;
            case C__PROPERTY__INFO__TYPE__OBJECT_BROWSER:
                if ($propertyDefinition[C__PROPERTY__UI][C__PROPERTY__UI__PARAMS]['multiselection']) {
                    $propertyEntity = new PropertyWriteEntity('Object Browser (multi)', [1, 2, 3]);
                    $propertyEntity->addDefinition('integer[]', 'Array of ids referencing existing cmdb objects.', [1, 2, 3]);
                } else {
                    $propertyEntity = new PropertyWriteEntity('Object Browser', 20);
                    $propertyEntity->addDefinition('integer', 'Id of an existing cmdb object or other entity (connector, license, etc...)', 20);
                }
                break;
            case C__PROPERTY__INFO__TYPE__TEXT:
                $propertyEntity = new PropertyWriteEntity('Text', 'Example text value');
                $propertyEntity->addDefinition('string', 'Valid string value with maximum 255 characters.', 'Example text value');
                break;
            case C__PROPERTY__INFO__TYPE__TEXTAREA:
                $propertyEntity = new PropertyWriteEntity('Text Area', 'Example text area value');
                $propertyEntity->addDefinition('string', 'Valid string value with maximum 65534 characters.', 'Example text area value');
                break;
            case C__PROPERTY__INFO__TYPE__UPLOAD:
                $propertyEntity = new PropertyWriteEntity('Upload', '__BASE_64_ENCODED_FILE__');
                $propertyEntity->addDefinition('string', 'String value representing a base64 encoded file', '__BASE_64_ENCODED_FILE__');
                break;
            case C__PROPERTY__INFO__TYPE__COMMENTARY:
                $propertyEntity = new PropertyWriteEntity('Commentary', 'Example commentary value');

                $propertyEntity->addDefinition('string', 'Valid string value with maximum 65534 characters', 'Example commentary value');
                break;
        }

        return $propertyEntity;
    }
}