<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Validation\Logical;

use idoit\Component\Property\Property;
use idoit\Module\Api\Exception\ValidationException;
use idoit\Module\Api\Validation\Validation;

/**
 * Class UnknownProperty
 *
 * @package Idoit\Module\Api\Validation\Logical
 */
class UnknownProperty extends Validation
{

    /**
     * Set property definition
     *
     * @param array|Property $propertyDefinition
     *
     * @return \idoit\Module\Api\Validation\Validation|void
     */
    public function setPropertyDefinition($propertyDefinition = null)
    {
        if ($propertyDefinition !== null && !($propertyDefinition instanceof Property) && !is_array($propertyDefinition)) {
            throw new ValidationException('The provided property definition needs to be an array or instance of Property.');
        }

        $this->propertyDefinition = $propertyDefinition;
    }

    /**
     * Validate value
     *
     * @return bool
     * @throws ValidationException
     */
    public function validate()
    {
        // Check whether property definition exists in properties
        if (empty($this->getPropertyDefinition())) {
            throw new ValidationException('unknown', 'Property \'' . $this->getTitle() . '\' is unknown.');
        }

        return true;
    }

    /**
     * UnknownProperty constructor.
     *
     * @param $title
     * @param $value
     * @param $propertyDefinition
     */
    public function __construct($title, $value, $propertyDefinition)
    {
        $this->setTitle($title)
            ->setValue($value)
            ->setPropertyDefinition($propertyDefinition);
    }
}
