<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

use idoit\Console\Command\Ldap\SyncCommand;
use idoit\Console\Command\Ldap\SyncDistinguishedNamesCommand;

/**
 * Class isys_model_console_ldap
 */
class isys_api_model_console_ldap extends isys_api_model_console
{
    /**
     * Syncronize ldap
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function sync(array $params = [])
    {
        // Check whether command exists
        $this->commandExists(SyncCommand::class);

        return $this->run(SyncCommand::NAME, $params['options'], $params['arguments']);
    }

    /**
     * Syncronize ldap dn
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function syncDn(array $params = [])
    {
        // Check whether command exists
        $this->commandExists(SyncDistinguishedNamesCommand::class);

        return $this->run(SyncDistinguishedNamesCommand::NAME, $params['options'], $params['arguments']);
    }
}