<?php

use idoit\AddOn\AuthableInterface;
use idoit\Component\Logger;
use idoit\Module\Api\SettingPage\ApiConfiguration;
use idoit\Module\Api\SettingPage\AttributeDocumentation;

/**
 * i-doit
 *
 * API module class
 *
 * @package     Modules
 * @subpackage  API
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_api extends isys_module implements \idoit\AddOn\AdministratableInterface
{
    /**
     * @param isys_module_request $request
     *
     * @return $this
     */
    public function init(isys_module_request $request)
    {
        return $this;
    }

    /**
     * @param isys_component_tree $tree
     * @param int                 $addonNodeId
     *
     * @return void
     * @throws Exception
     */
    public function buildAdministrationTree(isys_component_tree $tree, int $addonNodeId): void
    {
        $systemAuth = isys_module_system::getAuth();

        if (!$systemAuth->is_allowed_to(isys_auth::VIEW, 'JSONRPCAPI')) {
            return;
        }

        $nextId = $tree->count();
        $imageDir = isys_application::instance()->www_path . 'images/axialis/';

        $apiParentNode = $tree->add_node(
            ++$nextId,
            $addonNodeId,
            'JSON-RPC API',
            isys_helper_link::create_url([
                C__GET__MODULE_ID     => C__MODULE__SYSTEM,
                C__GET__MODULE_SUB_ID => C__MODULE__API
            ]),
            null,
            self::getWwwPath() . "assets/add-on-icon.svg",
            $_GET[C__GET__MODULE_ID] == C__MODULE__SYSTEM && $_GET[C__GET__MODULE_SUB_ID] == C__MODULE__API,
            null,
            null,
            $systemAuth->is_allowed_to(isys_auth::VIEW, 'JSONRPCAPI/GLOBAL')
        );

        if ($systemAuth->is_allowed_to(isys_auth::VIEW, 'JSONRPCAPI/OBJTYPE')) {
            $tree->add_node(
                ++$nextId,
                $apiParentNode,
                $this->language->get('LC__SYSTEM_SETTINGS__API__CATEGORIES_AND_ATTRIBUTES'),
                isys_helper_link::create_url([
                    C__GET__MODULE_ID     => C__MODULE__SYSTEM,
                    C__GET__MODULE_SUB_ID => C__MODULE__API,
                    C__GET__SETTINGS_PAGE => 'attributes',
                ]),
                null,
                "{$imageDir}basic/gear.svg",
                $_GET[C__GET__MODULE_ID] == C__MODULE__SYSTEM && $_GET[C__GET__MODULE_SUB_ID] == C__MODULE__API && $_GET[C__GET__SETTINGS_PAGE] === 'attributes'
            );
        }
    }

    public function start()
    {
        $navMode = (int)($_POST[C__GET__NAVMODE] ?: $_GET[C__GET__NAVMODE]);

        $template = isys_application::instance()->container->get('template');
        $database = isys_application::instance()->container->get('database');
        $language = isys_application::instance()->container->get('language');

        switch ($_GET[C__GET__SETTINGS_PAGE]) {
            case 'attributes':
                return (new AttributeDocumentation($template, $database, $language))->renderPage($navMode);

            default:
                return (new ApiConfiguration($template, $database, $language))->renderPage($navMode);
        }
    }
}
