<?php

namespace idoit\Module\Api\Controller;

use Exception;
use idoit\Component\Provider\DiInjectable;
use idoit\Controller\Responseable;
use idoit\Module\Api\Category\Descriptor;
use idoit\Module\Cmdb\Controller\Base;
use idoit\Module\Cmdb\Model\Tree;
use isys_application;
use isys_cmdb_dao_category;
use isys_component_tree;
use isys_controller;
use isys_format_json as JSON;
use isys_register;

/**
 * i-doit Location browser controller.
 *
 * @package     idoit\Module\Cmdb\Controller
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class AttributeDocumentation extends Base implements isys_controller, Responseable
{
    use DiInjectable;

    private $response;

    /**
     * Pre method gets called by the framework.
     */
    public function pre()
    {
        header('Content-Type: application/json');

        $this->response = [
            'success' => true,
            'data'    => null,
            'message' => null
        ];
    }

    /**
     * @param isys_register    $request
     * @param isys_application $app
     *
     * @return \idoit\View\Renderable|void
     */
    public function handle(isys_register $request, isys_application $app)
    {
        // Do nothing.
    }

    /**
     * @param isys_register       $p_request
     * @param isys_application    $p_application
     * @param isys_component_tree $p_tree
     *
     * @return \idoit\Tree\Node|void
     */
    public function tree(isys_register $p_request, isys_application $p_application, isys_component_tree $p_tree)
    {
        // Do nothing.
    }

    /**
     * @param isys_application $p_application
     *
     * @return \idoit\Model\Dao\Base|void
     */
    public function dao(isys_application $p_application)
    {
        // Do nothing.
    }

    /**
     * Method for receiving list of categories.
     *
     * @route  /api/get-category-list
     *
     * @param isys_register $request
     *
     * @return void
     * @throws Exception
     */
    public function getCategoryList(isys_register $request)
    {
        $categoryStore = [];
        $cmdbDao = isys_application::instance()->container->get('cmdb_dao');
        $language = isys_application::instance()->container->get('language');

        $categoryTypeAbbrTitles = [
            'g'        => $language->get('LC__CMDB__GLOBAL_CATEGORIES'),
            's'        => $language->get('LC__CMDB__SPECIFIC_CATEGORIES'),
            'g_custom' => $language->get('LC__CMDB__CUSTOM_CATEGORIES'),
        ];

        foreach (['g', 's', 'g_custom'] as $categoryTypeAbbr) {
            $categoryResource = $cmdbDao->get_isysgui("isysgui_cat{$categoryTypeAbbr}");

            // @see ID-8942 Initialize the category type.
            $categoryStore[$categoryTypeAbbrTitles[$categoryTypeAbbr]] = [];

            while ($categoryRow = $categoryResource->get_row()) {
                $parentTitle = '';
                $idField = "isysgui_cat{$categoryTypeAbbr}__id";
                $titleField = "isysgui_cat{$categoryTypeAbbr}__title";
                $parentField = "isysgui_cat{$categoryTypeAbbr}__parent";
                $typeField = "isysgui_cat{$categoryTypeAbbr}__type";

                // @see API-309 Skip 'view' categories
                if ($categoryRow[$typeField] == isys_cmdb_dao_category::TYPE_VIEW) {
                    continue;
                }

                // @see  API-196 ID-7042  Categories with "parents" need to display their names in order to make sense.
                if (isset($categoryRow[$parentField]) && $categoryRow[$parentField]) {
                    if ($categoryTypeAbbr === 'g') {
                        $parentTitle = $language->get($cmdbDao->get_catg_name_by_id_as_string($categoryRow[$parentField])) . ' > ';
                    } elseif ($categoryTypeAbbr === 's') {
                        // @see API-338 Use a different method to get 'parent' categories.
                        $parents = [];
                        $parentResult = $cmdbDao->cats_get_parent_cats($categoryRow[$idField], true);

                        while ($parentRow = $parentResult->get_row()) {
                            $parents[] = $language->get($parentRow['isysgui_cats__title']);
                        }

                        if (count($parents)) {
                            $parentTitle = implode(' / ', $parents) . ' > ';
                        }
                    }
                }

                $categoryStore[$categoryTypeAbbrTitles[$categoryTypeAbbr]][] = [
                    'value' => $categoryTypeAbbr . '.' . $categoryRow[$idField],
                    'title' => $parentTitle . $language->get($categoryRow[$titleField])
                ];
            }

            usort($categoryStore[$categoryTypeAbbrTitles[$categoryTypeAbbr]], function ($a, $b) {
                return strnatcasecmp($a['title'], $b['title']);
            });
        }

        $this->response['data'] = $categoryStore;
    }

    /**
     * Method for receiving list of categories.
     *
     * @route  /api/get-category-definition
     *
     * @param isys_register $request
     *
     * @return void
     * @throws Exception
     */
    public function getCategoryDefinition(isys_register $request)
    {
        $this->response['data'] = Descriptor::byId($_GET['categoryType'], $_GET['categoryId'])->getDefinition();
    }

    /**
     * Return the JSON and die.
     */
    public function post()
    {
        echo JSON::encode($this->response);
        die;
    }

    /**
     * @return array
     */
    public function getResponse()
    {
        return $this->response;
    }
}
