<?php

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\RequestModifier;
use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\ResponseModifier;

/**
 * ConnectorProcessor
 *
 * @package    idoit\Module\Api\Model\Category
 * @author     Selcuk Kekec <skekec@i-doit.com>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class ConnectorProcessor extends PortProcessor implements RequestModifier, ResponseModifier
{
    /**
     * Get cable property name
     *
     * @return string
     */
    protected function getCablePropertyName()
    {
        return 'cable_connection';
    }

    /**
     * Modify api request.
     *
     * @param array $request
     *
     * @return array
     */
    public function modifyRequest(array $request)
    {
        if (!isset($request['data']['fiber_wave_lengths']) || empty($request['data']['fiber_wave_lengths'])) {
            $request['data']['fiber_wave_lengths'] = null;
        }

        return $request;
    }


    /**
     * @param array $response
     *
     * @return array
     */
    public function modifyResponse(array $response)
    {
        $request = $this->getRequest();

        if ($request['option'] === 'read') {
            // @see API-384 Flatten the 'cable' array.
            $response = array_map(function ($entry) {
                if (is_array($entry['cable_connection'])) {
                    if (count($entry['cable_connection']) === 0) {
                        $entry['cable_connection'] = null;
                    } else {
                        $entry['cable_connection'] = current($entry['cable_connection']);
                    }
                }

                return $entry;
            }, $response);
        }

        return $response;
    }
}
