<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\SyncModifier;
use isys_application;
use isys_cmdb_dao_category_g_network_port;
use isys_request;

/**
 * PortProcessor
 *
 * @package idoit\Module\Api\Model\Category
 */
class LogicalPortProcessor extends AbstractCategoryProcessor implements SyncModifier
{
    /**
     * @param array $syncData
     *
     * @return array
     * @throws \Exception
     */
    public function modifySyncData(array $syncData)
    {
        $request = $this->getRequest();

        $dataId = (int)($syncData['data_id'] ?? 0);
        $objectId = (int)($request['object'] ?: $request['objID']);
        $isCreationRequest = in_array($request['option'], ['save', 'update', 'create'], true);

        if ($isCreationRequest) {
            if (isset($syncData['properties']['ports']['value'])) {
                // Go sure to always contain an array of ports.
                if (!is_array($syncData['properties']['ports']['value'])) {
                    $syncData['properties']['ports']['value'] = [$syncData['properties']['ports']['value']];
                }

                if (isset($request['data']['ports'])) {
                    // @see API-367 Check if we need to translate the 'port title' to its ID.
                    $portArray = [];
                    $result = isys_cmdb_dao_category_g_network_port::instance(isys_application::instance()->container->get('database'))->get_ports($objectId);

                    while ($row = $result->get_row()) {
                        $portArray[$row['isys_catg_port_list__title']] = (int)$row['isys_catg_port_list__id'];
                    }

                    foreach ($syncData['properties']['ports']['value'] as &$port) {
                        if (!is_numeric($port) && isset($portArray[$port])) {
                            $port = $portArray[$port];
                        }
                    }

                    $syncData['properties']['ports']['value'] = array_filter($syncData['properties']['ports']['value'], fn ($port) => is_numeric($port) && $port >= 0);
                } else {
                    // @see API-369 Don't assign a wrong port, if none was passed.
                    if ($dataId > 0) {
                        $request = isys_request::factory()
                            ->set_category_data_id($dataId)
                            ->set_object_id($objectId);

                        $ports = $this->getDao()->callback_property_ports($request);
                        $selectedPorts = array_filter($ports, fn ($port) => (bool)$port['sel']);
                        $selectedPortIds = array_map(fn ($port) => (int)$port['id'], $selectedPorts);

                        $syncData['properties']['ports']['value'] = $selectedPortIds;
                    }
                }
            }
        }

        return $syncData;
    }
}
