<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Oscar Pohl <opohl@i-doit.de>
 * @version    1.12.2
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\ResponseModifier;
use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\SyncModifier;
use idoit\Module\Report\SqlQuery\Structure\SelectCondition;
use idoit\Module\Report\SqlQuery\Structure\SelectSubSelect;
use isys_cmdb_dao_category_s_net;
use Throwable;

/**
 * Class NetProcessor
 *
 * @package idoit\Module\Api\Model\Cmdb\Category\Processor
 */
class NetProcessor extends AbstractCategoryProcessor implements SyncModifier, ResponseModifier
{
    /**
     * @var isys_cmdb_dao_category_s_net
     */
    protected $dao;

    /**
     * @param array $syncData
     *
     * @return array
     */
    public function modifySyncData(array $syncData)
    {
        $objectID = $this->request['object'];
        $layer2assignments = $syncData['properties']['layer2_assignments']['value'];

        // @see  API-276  prevent object from assigning itself
        if ($layer2assignments == $objectID) {
            $layer2assignments = $this->dao->get_assigned_layer_2_ids($objectID, true);
        } elseif (is_array($layer2assignments) && ($key = array_search($objectID, $layer2assignments)) !== false) {
            unset($layer2assignments[$key]);
            if (empty($layer2assignments)) {
                $layer2assignments = $this->dao->get_assigned_layer_2_ids($objectID, true);
            }
        }
        $syncData['properties']['layer2_assignments']['value'] = $layer2assignments;
        return $syncData;
    }

    /**
     * @param array $response
     *
     * @return array
     * @throws \isys_exception_database
     */
    public function modifyResponse(array $response)
    {
        $request = $this->getRequest();
        $dao = $this->getDao();

        if ($request['option'] === 'read') {
            /** @var SelectSubSelect $query */
            $usedAddressesSelect = $dao->get_property_by_key('free_addresses')[C__PROPERTY__DATA][C__PROPERTY__DATA__SELECT];

            // @see API-389 Load specific property values:
            $response = array_map(function ($entry) use ($dao, $usedAddressesSelect) {
                // Remove the 'address_v6' because it never contains anything.
                unset($entry['address_v6']);

                $entry['address_range'] = $entry['range_from'] . ' - ' . $entry['range_to'];
                $entry['address_with_suffix'] = $entry['address'] . ' / ' . $entry['cidr_suffix'];

                try {
                    // Fetch the select condition to have the same result as the object list.
                    $usedAddressesSelect->setSelectCondition(SelectCondition::factory(['isys_cats_net_list__isys_obj__id = ' . $dao->convert_sql_id($entry['objID'])]));
                    $entry['used_addresses'] = current($dao->retrieve((string) $usedAddressesSelect)->get_row());

                    // Unset this property, as its name is confusing.
                    unset($entry['free_addresses']);
                } catch (Throwable $e) {

                }

                return $entry;
            }, $response);
        }

        return $response;
    }
}
