<?php

namespace idoit\Module\Api\SettingPage;

use idoit\Component\Logger;
use idoit\Module\System\SettingPage\SettingPage;
use isys_application;
use isys_cmdb_dao;
use isys_component_template_navbar;
use isys_module_api;

/**
 * Class CustomTranslation
 *
 * @package idoit\Module\System\SettingPage
 */
class ApiConfiguration extends SettingPage
{
    /**
     * @param $navMode
     *
     * @return mixed|void
     * @throws \isys_exception_database
     */
    public function renderPage($navMode)
    {
        $navbar = isys_component_template_navbar::getInstance();
        $tenantSettings = isys_application::instance()->container->get('settingsTenant');
        $dao = new isys_cmdb_dao(isys_application::instance()->container->get('database_system'));
        $tenantId = $dao->convert_sql_id(isys_application::instance()->container->get('session')->get_mandator_id());

        if ($navMode == C__NAVMODE__SAVE) {
            $apiKey = $dao->convert_sql_text($_POST['C__ADDON__API__CONFIGURATION__API_KEY']);
            $dao->update("UPDATE isys_mandator SET isys_mandator__apikey = {$apiKey} WHERE isys_mandator__id = {$tenantId};");
            $dao->apply_update();

            $tenantSettings
                ->set('api.status', (int)$_POST['C__ADDON__API__CONFIGURATION__ACTIVE'])
                ->set('api.authenticated-users-only', (int)$_POST['C__ADDON__API__CONFIGURATION__FORCE_AUTHENTIFICATION'])
                ->set('api.strip-tags', (int)$_POST['C__ADDON__API__CONFIGURATION__STRIP_HTML'])
                ->set('api.log-level', (int)$_POST['C__ADDON__API__CONFIGURATION__LOG_LEVEL']);
        }

        $navbar
            ->hide_all_buttons()
            ->set_active(true, C__NAVBAR_BUTTON__EDIT)
            ->set_visible(true, C__NAVBAR_BUTTON__EDIT);

        if ($navMode == C__NAVMODE__EDIT) {
            $navbar
                ->set_active(false, C__NAVBAR_BUTTON__EDIT)
                ->set_visible(false, C__NAVBAR_BUTTON__EDIT)
                ->set_active(true, C__NAVBAR_BUTTON__SAVE)
                ->set_visible(true, C__NAVBAR_BUTTON__SAVE)
                ->set_active(true, C__NAVBAR_BUTTON__CANCEL)
                ->set_visible(true, C__NAVBAR_BUTTON__CANCEL);
        }

        $apiKey = $dao
            ->retrieve("SELECT isys_mandator__apikey FROM isys_mandator WHERE isys_mandator__id = {$tenantId};")
            ->get_row_value('isys_mandator__apikey');

        $rules = [
            'C__ADDON__API__CONFIGURATION__API_KEY'                => [
                'p_strValue' => $apiKey,
                'p_strClass' => 'input-small'
            ],
            'C__ADDON__API__CONFIGURATION__ACTIVE'                 => [
                'p_arData'        => get_smarty_arr_YES_NO(),
                'p_strSelectedID' => $tenantSettings->get('api.status', 0),
                'p_bDbFieldNN'    => true,
                'p_strClass'      => 'input-small'
            ],
            'C__ADDON__API__CONFIGURATION__FORCE_AUTHENTIFICATION' => [
                'p_arData'        => get_smarty_arr_YES_NO(),
                'p_strSelectedID' => $tenantSettings->get('api.authenticated-users-only', 1),
                'p_bDbFieldNN'    => true,
                'p_strClass'      => 'input-small'
            ],
            'C__ADDON__API__CONFIGURATION__STRIP_HTML'             => [
                'p_arData'        => get_smarty_arr_YES_NO(),
                'p_strSelectedID' => $tenantSettings->get('api.strip-tags', 0),
                'p_bDbFieldNN'    => true,
                'p_strClass'      => 'input-small'
            ],
            'C__ADDON__API__CONFIGURATION__LOG_LEVEL'              => [
                'p_arData'        => [
                    Logger::ERROR   => 'ERROR',
                    Logger::WARNING => 'WARNING',
                    Logger::INFO    => 'INFO',
                    Logger::DEBUG   => 'DEBUG',
                ],
                'p_strSelectedID' => $tenantSettings->get('api.log-level', Logger::WARNING),
                'p_strClass'      => 'input-small',
                'p_bSort'         => false
            ]
        ];

        $this->tpl
            ->assign('content_title', $this->lang->get('LC__ADDON__API__CONFIGURATION'))
            ->smarty_tom_add_rules('tom.content.bottom.content', $rules)
            ->include_template('contentbottomcontent', isys_module_api::getPath() . '/templates/configuration.tpl');
    }
}
