<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Validation\Property;

use idoit\Module\Api\Exception\ValidationException;
use idoit\Module\Api\Validation\PropertyValidation;

/**
 * Class Text
 *
 * @package idoit\Module\Api\Validation\Property
 */
class Timeperiod extends Text
{
    /**
     * Validate value
     *
     * @return bool
     * @throws ValidationException
     */
    public function validate()
    {
        // @see API-289
        if (strlen($this->getValue()) === 0) {
            return true;
        }

        // text validation
        parent::validate();

        // Check for right format: 00:00 - 00:00
        preg_match('~([01]?[0-9]|2[0-3]):?([0-5]?[0-9])?~', $this->getValue(), $matches);

        if (empty($matches)) {
            throw new ValidationException($this->getPropertyType(), 'Property has to be a valid timeperiod string. (e.g. "hh:mm - hh:mm")');
        }

        return true;
    }

    /**
     * @return int
     */
    public function getMaximumLength()
    {
        return 13;
    }

}
