<?php
/**
 * i-doit
 *
 * Module initializer
 *
 * @package     API
 * @subpackage  Modules
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

// Adding the PSR-4 autoloader for category processors
use Symfony\Component\Config\FileLocator;
use Symfony\Component\Routing\Loader\PhpFileLoader;

\idoit\Psr4AutoloaderClass::factory()->addNamespace('idoit\Module\Api', __DIR__ . '/src/');

// Add classmap for legacy code.
\idoit\Component\Autoloader::appendClassmap(include(__DIR__ . '/classmap.php'));

// Get component registry
if ($registry = isys_application::instance()->container->get('components.registry')) {
    // Register api provided react components
    $registry->register('idoit.addon.api', 'src/classes/modules/api/react/dist/index.min.js');
}

// Add 'API' relevant routes.
isys_application::instance()->container->get('routes')
    ->addCollection((new PhpFileLoader(new FileLocator(__DIR__)))->load('config/routes.php'));
