<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Leonard Fischer <lfischer@i-doit.com>
 * @version    1.11
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\SyncModifier;
use isys_cmdb_dao_category_g_contact;

/**
 * Class ContactProcessor
 *
 * @package idoit\Module\Api\Model\Cmdb\Category\Processor
 */
class ContactProcessor extends AbstractCategoryProcessor implements SyncModifier
{
    /**
     * @return array
     */
    public function getAffectedPropertiesBySync()
    {
        return [
            'contact'
        ];
    }

    /**
     * Modify sync data.
     *
     * @param array $syncData
     *
     * @return array
     * @throws \isys_exception_database
     */
    public function modifySyncData(array $syncData)
    {
        // Get request information.
        $request = $this->getRequest();
        $contactDao = $this->getDao();

        // Skip non-save requests.
        if (!in_array($request['option'], ['save', 'update'], true)) {
            return $syncData;
        }

        // @see API-264
        if (isset($request['data']['contact_object']) && !isset($request['data']['contact'])) {
            $request['data']['contact'] = $request['data']['contact_object'];
            $syncData['properties']['contact'] = $syncData['properties']['contact_object'];
        }

        // @see  API-225  If the request provides no specific contact, we re-set it.
        if (!isset($request['data']['contact']) && isset($syncData['data_id']) && is_numeric($syncData['data_id'])) {
            $data = $contactDao->get_data($syncData['data_id'])->get_row();

            // @see API-264
            if (is_numeric($data['isys_cats_person_list__isys_obj__id'])) {
                $syncData['properties']['contact']['value'] = (int)$data['isys_cats_person_list__isys_obj__id'];
            } else if (is_numeric($data['isys_cats_person_group_list__isys_obj__id'])) {
                $syncData['properties']['contact']['value'] = (int)$data['isys_cats_person_group_list__isys_obj__id'];
            } else if (is_numeric($data['isys_cats_organization_list__isys_obj__id'])) {
                $syncData['properties']['contact']['value'] = (int)$data['isys_cats_organization_list__isys_obj__id'];
            }
        }
        unset($syncData['properties']['contact_object']);

        return $syncData;
    }
}
