<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Leonard Fischer <lfischer@i-doit.com>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Dialog\DialogPlusAdmin;
use idoit\Module\Api\Exception\JsonRpc\ParameterException;
use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\ResponseModifier;

/**
 * Class ModelProcessor
 *
 * @package idoit\Module\Api\Model\Cmdb\Category\Processor
 */
class PersonProcessor extends AbstractCategoryProcessor implements ResponseModifier
{
    /**
     * Modify api response
     *
     * @param array $response
     *
     * @return array
     */
    public function modifyResponse(array $response)
    {
        // Get request.
        $request = $this->getRequest();

        // Check whether api request is 'read' and response object has results
        if (\is_array($request) && $request['option'] === 'read' && \is_array($response) && \count($response)) {
            foreach ($response as &$responseItem) {
                // Change "misses" and "mister" with "m" and "f".
                if (isset($responseItem['salutation']['id']) && !empty($responseItem['salutation']['id'])) {
                    $responseItem['salutation'] = $responseItem['salutation']['id'] === 'm' ? 'm' : 'f';
                }
            }
        }

        return array_values($response);
    }
}
