<?php

namespace idoit\Module\Api\SettingPage;

use idoit\Component\Logger;
use idoit\Module\System\SettingPage\SettingPage;
use isys_auth;
use isys_auth_system;
use isys_module_api;

/**
 * Class CustomTranslation
 *
 * @package idoit\Module\System\SettingPage
 */
class AttributeDocumentation extends SettingPage
{
    /**
     * @param $navMode
     *
     * @return mixed|void
     * @throws \isys_exception_database
     */
    public function renderPage($navMode)
    {
        // Check right system.
        if (class_exists('isys_auth_system')) {
            isys_auth_system::instance()->check(isys_auth::VIEW, 'JSONRPCAPI/OBJTYPE');
            $l_edit_right = isys_auth_system::instance()->is_allowed_to(isys_auth::EDIT, 'JSONRPCAPI');
        } else {
            $l_edit_right = true;
        }

        // Create translations.
        $translations = [
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__LOADING_CATEGORIES',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__PLEASE_SELECT_A_CATEGORY',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__LOADING_CATEGORY_INFORMATION',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__CATEGORY_INFORMATION',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ID',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__CONSTANT',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__MULTIVALUE',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__TITLE',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__KEY',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__TYPE',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__DATA_TYPE_READ',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__DATA_TYPE_WRITE',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__EXAMPLE',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__EXAMPLES',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__EXAMPLES__READ',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__EXAMPLES__WRITE',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__DESCRIPTION',
            'LC__UNIVERSAL__YES',
            'LC__UNIVERSAL__NO',
        ];

        foreach ($translations as $index => $languageConstant) {
            $translations[$languageConstant] = $this->lang->get($languageConstant);

            unset($translations[$index]);
        }

        $this->tpl
            ->assign('translations', $translations)
            ->assign('content_title', $this->lang->get('LC__ADDON__API__ATTRIBUTE_DOCUMENTATION'))
            ->include_template('contentbottomcontent', isys_module_api::getPath() . '/templates/attribute-configuration.tpl');
    }
}
