<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Validation\Property;

use idoit\Module\Api\Exception\ValidationException;

/**
 * Class Text
 *
 * @package idoit\Module\Api\Validation\Property
 */
class Time extends Text
{
    /**
     * Validate value
     *
     * @return bool
     * @throws ValidationException
     */
    public function validate()
    {
        // @see API-289
        if (strlen($this->getValue()) === 0) {
            return true;
        }

        parent::validate();

        // Check the general syntax.
        if (!preg_match('~\d\d:\d\d~', $this->getValue())) {
            throw new ValidationException(
                $this->getPropertyType(),
                'Property has to be a valid time string (e.g. "hh:mm")'
            );
        }

        [$hour, $minute] = explode(':', $this->getValue());

        if ($hour < 0 || $hour >= 24) {
            throw new ValidationException(
                $this->getPropertyType(),
                'Property has to be a valid time string, the hour needs to be a number between 0 and 23. (e.g. "hh:mm")'
            );
        }

        if ($minute < 0 || $minute >= 59) {
            throw new ValidationException(
                $this->getPropertyType(),
                'Property has to be a valid time string, the minute needs to be a number between 0 and 59. (e.g. "hh:mm")'
            );
        }

        return true;
    }

    /**
     * @return int
     */
    public function getMaximumLength()
    {
        return 5;
    }
}
