<?php
/**
 * i-doit
 *
 * Module initializer
 *
 * @package     API
 * @subpackage  Modules
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

use idoit\Component\Autoloader;
use idoit\Psr4AutoloaderClass;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\Routing\Loader\PhpFileLoader;

// Adding the PSR-4 autoloader for category processors
Psr4AutoloaderClass::factory()->addNamespace('idoit\Module\Api', __DIR__ . '/src/');

// Add classmap for legacy code.
Autoloader::appendClassmap(include(__DIR__ . '/classmap.php'));

// Get component registry
if ($registry = isys_application::instance()->container->get('components.registry')) {
    // Register api provided react components
    $registry->register('idoit.addon.api', 'src/classes/modules/api/react/dist/index.min.js');
}

// Add 'API' relevant routes.
isys_application::instance()->container->get('routes')
    ->addCollection((new PhpFileLoader(new FileLocator(__DIR__)))->load('config/routes.php'));
