<?php

namespace idoit\Module\Api\Endpoint\v2\Cmdb\Object;

use Exception;
use idoit\Api\EndpointDefinition;
use idoit\Api\JsonRpcResponse;
use idoit\Api\Parameter\OptionalParameter;
use idoit\Api\Parameter\Parameter;
use idoit\Api\Parameter\RequiredParameter;
use idoit\Module\Api\Endpoint\v2\Cmdb\AbstractCmdbEndpoint;
use idoit\Module\Api\Exception\JsonRpc\InternalErrorException;
use idoit\Module\Cmdb\Component\CategoryChanges\Changes;
use idoit\Module\Cmdb\Component\SyncMerger\Config;
use idoit\Module\Cmdb\Component\SyncMerger\Merger;
use isys_application;
use isys_auth;
use isys_cmdb_dao_category_g_global;
use isys_module_cmdb;
use Symfony\Component\HttpFoundation\Request;

/**
 * CMDB object save endpoint (v2).
 *
 * @see       API-484
 * @package   idoit\Api
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class Save extends AbstractCmdbEndpoint
{
    public function getDefinition(): EndpointDefinition
    {
        return new EndpointDefinition('cmdb.object.save.v2', 'Will read a singular object from i-doit, can include category information', [
            new RequiredParameter('object', Parameter::TYPE_INTEGER, 'Numeric object ID', fn ($id) => $id > 0),
            new OptionalParameter('title', Parameter::TYPE_STRING, 'A new title for the object', fn ($title) => trim($title) !== ''),
            new OptionalParameter('type', Parameter::TYPE_STRING, 'A new type for the object', fn ($type) => is_int($type) || (strpos($type, 'C__OBJTYPE__') === 0 && defined($type))),
            new OptionalParameter('sys-id', Parameter::TYPE_STRING, 'A new SYS-ID for the object', fn ($title) => trim($title) !== ''),
            new OptionalParameter('category', Parameter::TYPE_STRING, 'A new category for the object', fn ($category) => is_int($category) || (is_string($category) && trim($category) !== '')),
            new OptionalParameter('purpose', Parameter::TYPE_STRING, 'A new purpose for the object', fn ($purpose) => is_int($purpose) || (is_string($purpose) && trim($purpose) !== '')),
            new OptionalParameter('tags', Parameter::TYPE_ARRAY, 'A array of tags for the object', function ($tags) {
                foreach ($tags as $tag) {
                    if (is_string($tag) && trim($tag) === '') {
                        throw new Exception("You provided an empty tag, this is not allowed.");
                    }
                }

                return true;
            }),
            new OptionalParameter('description', Parameter::TYPE_STRING, 'A new description for the object', fn ($title) => trim($title) !== ''),
        ]);
    }

    /**
     * @todo Finish this endpoint
     */
    public function request(Request $request): JsonRpcResponse
    {
        $objectId = $request->request->get('object');

        isys_module_cmdb::getAuth()->check_rights_obj_and_category(isys_auth::EDIT, $objectId, 'C__CATG__GLOBAL');

        $database = isys_application::instance()->container->get('database');
        $dao = isys_cmdb_dao_category_g_global::instance($database);

        $currentCategoryData = $dao->get_data(null, $objectId)
            ->get_row();

        if (empty($currentCategoryData)) {
            throw new InternalErrorException('No object exists with ID ' . $objectId);
        }

        $fakeEntry = [
            Config::CONFIG_DATA_ID    => $currentCategoryData['isys_catg_global_list__id'],
            Config::CONFIG_PROPERTIES => []
        ];

        $changedData = array_filter([
            'title'       => $request->request->get('title'),
            'type'        => $request->request->get('type'),
            'sysid'       => $request->request->get('sys-id'),
            'category'    => $request->request->get('category'),
            'purpose'     => $request->request->get('purpose'),
            'tag'         => $request->request->get('tags'),
            'description' => $request->request->get('description'),
        ], fn ($value) => $value !== null);

        $currentData = Merger::instance(Config::instance($dao, $objectId, $fakeEntry))
            ->flattenSyncData();
        $changer = Changes::instance($dao, $objectId, $currentCategoryData['isys_catg_global_list__id'], $currentData, $changedData);
        $changer->processChanges();

        /*

        // @todo Call processor

        // @see API-191 Check and react to the object lock.
        $this->checkObjectLock($objectId);

        $dao->sync();
        // $dao->logbook_update('C__LOGBOOK_EVENT__CATEGORY_CHANGED', $changer);

        // @see API-191 Unlock the object once the request has finished.
        $this->unlockObject($objectId);
        */

        return new JsonRpcResponse(['success' => true]);
    }
}
