<?php

namespace idoit\Module\Api\Endpoint\v2\Cmdb\Report;

use idoit\Api\EndpointDefinition;
use idoit\Api\JsonRpcResponse;
use idoit\Module\Api\Endpoint\v2\Cmdb\AbstractCmdbEndpoint;
use isys_auth;
use isys_exception_auth;
use isys_module_report;
use isys_report_dao;
use Symfony\Component\HttpFoundation\Request;

/**
 * CMDB report list endpoint (v2).
 *
 * @see       API-484
 * @package   idoit\Api
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class ListEntries extends AbstractCmdbEndpoint
{
    public function getDefinition(): EndpointDefinition
    {
        return new EndpointDefinition('cmdb.report.list.v2', 'Lists up all available reports, based on your rights. To execute a report use "cmdb.report.read.v2".');
    }

    public function request(Request $request): JsonRpcResponse
    {
        $responseData = [];
        $dao = isys_report_dao::instance();

        $reports = $dao->get_reports(null, null, null, true, false);

        foreach ($reports as $report) {
            try {
                isys_module_report::getAuth()->custom_report(isys_auth::VIEW, $report['isys_report__id']);
            } catch (isys_exception_auth $e) {
                continue;
            }

            // Skip reports with placeholders
            if (!$dao->hasQueryOnlyInternalPlaceholder($report['isys_report__query'])) {
                continue;
            }

            $responseData[] = [
                'id'          => (int)$report['isys_report__id'],
                'category'    => $report['category_title'],
                'title'       => $report['isys_report__title'],
                'description' => $report['isys_report__description'],
                'created'     => $report['isys_report__datetime'],
                'modified'    => $report['isys_report__last_editied'],
            ];
        }

        return new JsonRpcResponse($responseData);
    }
}
