<?php

namespace idoit\Module\Api\Endpoint\v2\System\Endpoints;

use idoit\Api\EndpointDefinition;
use idoit\Api\EndpointInterface;
use idoit\Api\JsonRpcResponse;
use idoit\Api\Parameter\OptionalParameter;
use idoit\Api\Parameter\RequiredParameter;
use isys_application;
use Symfony\Component\HttpFoundation\Request;

class Read implements EndpointInterface
{
    public function getDefinition(): EndpointDefinition
    {
        return new EndpointDefinition('system.endpoints.read.v2', 'Will read all registered endpoints of the new structure', [], [
            'basic example' => [
                "version" => "2.0",
                "method"  => "system.endpoints.read.v2",
                "params"  => [
                    "apikey" => "api-key"
                ],
                "id"      => 1
            ]
        ]);
    }

    public function request(Request $request): JsonRpcResponse
    {
        $responseData = [];

        // Fetch all endpoints.
        $endpoints = isys_application::instance()->container->get('api.endpoints')
            ->all();

        foreach ($endpoints as $name => $endpoint) {
            /** @var EndpointInterface $endpoint */

            $parameters = [
                'required' => [],
                'optional' => [],
            ];

            foreach ($endpoint->getDefinition()->getRequiredParameters() as $parameter) {
                /** @var RequiredParameter $parameter */
                $parameters['required'][$parameter->getName()] = [
                    'type'           => $parameter->getType(),
                    'description'    => $parameter->getDescription(),
                    'has-validation' => $parameter->getValidation() !== null
                ];
            }

            foreach ($endpoint->getDefinition()->getOptionalParameters() as $parameter) {
                /** @var OptionalParameter $parameter */
                $parameters['optional'][$parameter->getName()] = [
                    'type'           => $parameter->getType(),
                    'description'    => $parameter->getDescription(),
                    'has-validation' => $parameter->getValidation() !== null,
                    'default-value'  => $parameter->getDefaultValue()
                ];
            }

            $responseData[$name] = array_filter([
                'description'     => $endpoint->getDefinition()->getDescription(),
                'parameters'      => $parameters,
                'example-request' => $endpoint->getDefinition()->getExampleRequest(),
                'example-response' => $endpoint->getDefinition()->getExampleResponse(),
            ]);
        }

        ksort($responseData);

        return new JsonRpcResponse($responseData);
    }
}
