<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\ResponseModifier;
use isys_application;
use Throwable;

/**
 * Image processor
 *
 * @package idoit\Module\Api\Model\Category
 */
class ImageProcessor extends AbstractCategoryProcessor implements ResponseModifier
{
    /**
     * @param array $response
     *
     * @return array
     * @throws \Exception
     */
    public function modifyResponse(array $response)
    {
        // Get request
        $request = $this->getRequest();

        // Check whether api request is 'read' and response object has results
        if (is_array($request) && $request['option'] === 'read' && count($response) > 0) {
            $routeGenerator = isys_application::instance()->container->get('route_generator');

            foreach ($response as &$entry) {
                try {
                    $entry['image'] = $routeGenerator->generate('cmdb.object.image', ['objectId' => $entry['object'] ?? $entry['objID']]);
                } catch (Throwable $e) {
                    // @todo API-505 this is a workaround and should not be necessary, after the bootstrapping has been unified.
                    $entry['image'] = rtrim(isys_application::instance()->www_path, '/') . '/cmdb/object/image/' . ((int)$entry['object'] ?? $entry['objID']);
                }

                unset($entry['image_selection']);
            }

        }

        return array_values($response);
    }
}
