<?php

namespace idoit\Module\Api\PushIdentifier\SyncNormalizer\DataShapes;

use idoit\Module\Api\Model\External\Config;
use idoit\Module\Api\Model\External\Handler\CiObject;
use idoit\Module\Api\Model\External\Push;
use idoit\Module\Api\PushIdentifier\PushIdentifier;
use idoit\Module\Cmdb\Component\SyncNormalizer\DataNormalizerProviderConfig;
use idoit\Module\Cmdb\Component\SyncNormalizer\DataShapes\AbstractBrowserShape;
use idoit\Module\Cmdb\Component\SyncNormalizer\DataShapes\ShapeInterface;
use isys_application;
use isys_format_json;

class PushIdentifierShape extends AbstractBrowserShape implements ShapeInterface
{
    const KEYS = [
        'extType',
        'extId',
        'title',
        'class'
    ];

    /**
     * @param DataNormalizerProviderConfig $config
     * @param string                       $propertyKey
     * @param array                        $requestData
     *
     * @return mixed|void
     */
    public function handle(DataNormalizerProviderConfig $config, string $propertyKey, array $requestData)
    {
        $dao = isys_application::instance()->container->get('cmdb_dao');

        if (isset($this->getValue()['data'])) {
            $pushData = $this->getValue();
            $pushConfig = new Config($pushData['extType'], $pushData['extId'], $pushData['title'], $pushData['class'], $pushData['data']);
            (new Push($pushConfig))->prepare()->sync();
        }

        $title = $this->getValue()['title'];
        $class = $this->getValue()['class'];
        $extId = $this->getValue()['extId'];
        $extType = $this->getValue()['extType'];

        $ciObject = new CiObject($class, $title, $extType, $extId, PushIdentifier::OBJECT);
        $ciObject->find();

        if (!$ciObject->getRefId()) {
            $ciObject->create()
                ->createIdentifier();
        }

        $this->setValue($ciObject->getRefId());
    }
}
