<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Session;

use isys_application;

/**
 * Class SessionIdSession
 *
 * @package idoit\Module\Api\Session
 */
class SessionIdSession extends UserSession
{
    /**
     * SessionIdSession constructor.
     *
     * @param $sessionId
     * @param $apiKey
     * @param $sessionComponent
     */
    public function __construct($sessionId, $apiKey, $sessionComponent)
    {
        $this->setSessionId($sessionId)
            ->setApiKey($apiKey)
            ->setSessionComponent($sessionComponent);
    }

    /**
     * Is persistent
     *
     * @return bool
     */
    public function isPersistent()
    {
        return true;
    }

    /**
     * Login user by sessionId
     *
     * @return bool
     * @throws \isys_exception_api
     */
    public function login()
    {
        // Check whether session id was provided
        if (empty($this->getSessionId())) {
            throw new \Exception('Please provide a session id.');
        }

        // Initialize session
        $this->initialize();

        // Try to login
        return $this->getSessionComponent()
            ->apikey_login($this->getApiKey(), null, $this->getSessionId());
    }

    /**
     * Initialize login procedure
     *
     * @return bool
     * @throws \Exception
     */
    protected function initialize()
    {
        // Get mandator by api key
        $mandatorId = $this->getMandatorIdByApiKey($this->getApiKey());

        // Connect mandator now
        $this->getSessionComponent()
            ->connect_mandator($mandatorId);

        // Get user by credentials now
        $userData = $this->getUserBySessionId($this->getSessionId());

        $this->setUserId($userData['id'])
            ->setUsername($userData['userName'])
            ->setSessionId($userData['sessionId']);

        return true;
    }

    public function logout()
    {
        $this->refreshSession();
    }

    /**
     * Get userId by credentials
     *
     * @param $sessionId
     *
     * @return array
     * @throws \Exception
     */
    public function getUserBySessionId($sessionId)
    {
        $db = isys_application::instance()->container->get('database');

        $sql = "SELECT object.isys_obj__id AS id, sess.isys_user_session__php_sid AS sessionId, ps.isys_cats_person_list__title AS userName
            FROM isys_obj object
            INNER JOIN isys_user_session sess ON object.isys_obj__id = sess.isys_user_session__isys_obj__id
            INNER JOIN isys_cats_person_list ps ON object.isys_obj__id = ps.isys_cats_person_list__isys_obj__id
            WHERE sess.isys_user_session__php_sid = '" . $db->escape_string($this->getSessionId()) . "';";

        $resource = $db->query($sql);

        if ($db->num_rows($resource)) {
            return $db->fetch_row_assoc($resource);
        }
        $this->getSessionComponent()->destroy();
        throw new \Exception('Unable to get user by sessionId');
    }
}
