<?php

namespace idoit\Module\Api\SettingPage;

use idoit\Module\System\SettingPage\SettingPage;
use isys_auth;
use isys_module_api;

/**
 * Class CustomTranslation
 *
 * @package idoit\Module\System\SettingPage
 */
class AttributeDocumentation extends SettingPage
{
    /**
     * @param $navMode
     *
     * @return void
     * @throws \isys_exception_auth
     */
    public function renderPage($navMode)
    {
        // Check right system.
        isys_module_api::getAuth()->check(isys_auth::VIEW, 'CATEGORIES_ATTRIBUTES');

        // Create translations.
        $translations = [
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__LOADING_CATEGORIES',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__PLEASE_SELECT_A_CATEGORY',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__LOADING_CATEGORY_INFORMATION',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__CATEGORY_INFORMATION',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ID',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__CONSTANT',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__MULTIVALUE',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__TITLE',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__KEY',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__TYPE',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__DATA_TYPE_READ',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__DATA_TYPE_WRITE',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__EXAMPLE',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__EXAMPLES',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__EXAMPLES__READ',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__EXAMPLES__WRITE',
            'LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__DESCRIPTION',
            'LC__UNIVERSAL__YES',
            'LC__UNIVERSAL__NO',
        ];

        foreach ($translations as $index => $languageConstant) {
            $translations[$languageConstant] = $this->lang->get($languageConstant);

            unset($translations[$index]);
        }

        $this->tpl
            ->assign('translations', $translations)
            ->assign('content_title', $this->lang->get('LC__ADDON__API__ATTRIBUTE_DOCUMENTATION'))
            ->include_template('contentbottomcontent', isys_module_api::getPath() . '/templates/attribute-configuration.tpl');
    }
}
