<?php
/**
 * i-doit
 *
 * Module initializer
 *
 * @package     API
 * @subpackage  Modules
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

use idoit\Component\Autoloader;
use idoit\Psr4AutoloaderClass;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\Routing\Loader\PhpFileLoader;

// Adding the PSR-4 autoloader for category processors
Psr4AutoloaderClass::factory()->addNamespace('idoit\Module\Api', __DIR__ . '/src/');

// Add classmap for legacy code.
Autoloader::appendClassmap(include(__DIR__ . '/classmap.php'));

// Add 'API' relevant routes.
isys_application::instance()->container->get('routes')
    ->addCollection((new PhpFileLoader(new FileLocator(__DIR__)))->load('config/routes.php'));

// @see API-501 Register this setting as 'system setting' so that it appears in the admin center.
isys_application::instance()->container->get('settingsSystem')
    ->extend([
        'LC__ADDON__API' => [
            'api.authenticated-users-only' => [
                'title'   => 'LC__ADDON__API__CONFIGURATION__FORCE_AUTHENTIFICATION',
                'type'    => 'select',
                'default' => '1',
                'options' => [
                    '0' => 'LC__UNIVERSAL__NO',
                    '1' => 'LC__UNIVERSAL__YES'
                ]
            ]
        ]
    ]);
