<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

use idoit\Console\Command\Ldap\SyncCommand as CoreSyncCommand;
use idoit\Console\Command\Ldap\SyncDistinguishedNamesCommand as CoreSyncDistinguishedNamesCommand;
use idoit\Module\Ldap\Console\Command\SyncCommand;
use idoit\Module\Ldap\Console\Command\SyncDistinguishedNamesCommand;

/**
 * Class isys_model_console_ldap
 */
class isys_api_model_console_ldap extends isys_api_model_console
{
    /**
     * Syncronize ldap
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function sync(array $params = [])
    {
        // @see ID-10379 Keep this for older i-doit versions.
        try {
            // Check whether command exists
            $this->commandExists(CoreSyncCommand::class);

            return $this->run(CoreSyncCommand::NAME, $params['options'], $params['arguments']);
        } catch (Throwable $e) {

        }

        // Check whether command exists
        $this->commandExists(SyncCommand::class);

        return $this->run(SyncCommand::NAME, $params['options'], $params['arguments']);
    }

    /**
     * Syncronize ldap dn
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function syncDn(array $params = [])
    {
        // @see ID-10379 Keep this for older i-doit versions.
        try {
            // Check whether command exists
            $this->commandExists(CoreSyncDistinguishedNamesCommand::class);

            return $this->run(CoreSyncDistinguishedNamesCommand::NAME, $params['options'], $params['arguments']);
        } catch (Throwable $e) {

        }

        // Check whether command exists
        $this->commandExists(SyncDistinguishedNamesCommand::class);

        return $this->run(SyncDistinguishedNamesCommand::NAME, $params['options'], $params['arguments']);
    }
}
