<?php

use idoit\Module\License\LicenseServiceFactory;

/**
 * i-doit APi
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_api_model_idoit_addons implements isys_api_model_interface
{
    /**
     * Read installed addons for tenant
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function read($params)
    {
        return [
            'success' => true,
            'result'  => $this->getModules(
                isys_application::instance()->container->get('session')->get_mandator_id(),
                (bool)$params['coreModules']
            )
        ];
    }

    /**
     * Get modules of mandator
     *
     * @param int  $mandatorId
     * @param bool $coreModules
     *
     * @return array
     * @throws Exception
     */
    private function getModules($mandatorId, $coreModules = false)
    {
        global $g_absdir, $g_product_info, $g_license_token;

        // Create a new license service instance.
        $licenseService = LicenseServiceFactory::createDefaultLicenseService(
            isys_application::instance()->container->get('database_system'),
            $g_license_token
        );

        // Retrieve all licensed add-ons.
        $licensedAddons = $licenseService->getLicensedAddOns();

        // Create module manager instance
        $moduleManager = new isys_module_manager(isys_application::instance()->container->get('database'));

        // Setup path to modules directory
        $modulesDirectory = $g_absdir . '/src/classes/modules/';

        // Create directory handle
        $handle = opendir($modulesDirectory);

        // Iterate over module directories
        while (($moduleDirectory = readdir($handle)) !== false) {
            // Check whether directory is an module folder
            if (is_dir($modulesDirectory . $moduleDirectory) && strpos($moduleDirectory, '.') !== 0 && $moduleDirectory !== 'open') {
                // Check whether package.json exists
                if (file_exists($modulesDirectory . $moduleDirectory . '/package.json')) {
                    // Parse package json
                    $packageJson = json_decode(file_get_contents($modulesDirectory . $moduleDirectory . '/package.json'), true);

                    // Pro module should be considered as always active
                    if ($moduleDirectory === 'pro') {
                        $addons[] = [
                            'title'     => $packageJson['title'] ?: $packageJson['name'],
                            'key'       => $packageJson['identifier'],
                            'version'   => $g_product_info['version'],
                            'author'    => [
                                'name' => $packageJson['author']
                            ],
                            'licensed'  => $licenseService->isTenantLicensed($mandatorId),
                            'active'    => true,
                            'installed' => true,
                        ];

                        continue;
                    }

                    // Skip core modules
                    if (!$coreModules && $packageJson['type'] === 'core') {
                        continue;
                    }

                    // Module information store
                    $addOnInformation = [
                        'title'     => $packageJson['title'] ?: $packageJson['name'],
                        'key'       => $packageJson['identifier'],
                        'version'   => $packageJson['version'],
                        'author'    => [
                            'name' => $packageJson['author']
                        ],
                        'licensed'  => true,
                        'active'    => false,
                        'installed' => false,
                    ];

                    // Get module id
                    $moduleId = $moduleManager->is_installed($packageJson['identifier']);

                    // Check whether packageJson is present and module is installed
                    if ($packageJson && $moduleId) {
                        // Setup module information and status
                        $addOnInformation['active'] = (bool)$moduleManager->is_active($packageJson['identifier']);
                        $addOnInformation['licensed'] = true;
                        $addOnInformation['installed'] = true;

                        // Check whether module specific license is needed.
                        if ($packageJson['licence']) {
                            // Until we checked the actual license data, we assume the add-on is not licensed.
                            $addOnInformation['licensed'] = false;

                            if (isset($licensedAddons[$packageJson['identifier']]['licensed']) && is_bool($licensedAddons[$packageJson['identifier']]['licensed'])) {
                                $addOnInformation['licensed'] = $licensedAddons[$packageJson['identifier']]['licensed'];
                            }
                        }
                    }

                    // Add module information to addons store
                    $addons[] = $addOnInformation;
                }
            }
        }

        // Sort addons by id
        usort($addons, function ($a, $b) {
            return $a['id'] - $b['id'];
        });

        return $addons;
    }

}
