<?php

namespace idoit\Module\Api\Endpoint\v2\Cmdb\External;

use idoit\Api\EndpointDefinition;
use idoit\Api\JsonRpcResponse;
use idoit\Api\Parameter\Parameter;
use idoit\Api\Parameter\RequiredParameter;
use idoit\Module\Api\Endpoint\v2\Cmdb\AbstractCmdbEndpoint;
use idoit\Module\Api\Model\External\Config;
use idoit\Module\Api\Model\External\Logger;
use idoit\Module\Api\Model\External\Push as PushModel;
use idoit\Module\Cmdb\Component\CategoryLogger\CmdbLogger;
use Symfony\Component\HttpFoundation\Request;

/**
 * CMDB category externla push
 *
 * @see       API-484
 * @package   idoit\Api
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class Push extends AbstractCmdbEndpoint
{
    public function getDefinition(): EndpointDefinition
    {
        return new EndpointDefinition('cmdb.external.push.v2', 'LC__ADDON__API__ENDPOINT__CMDB_EXTERNAL_PUSH', [
            new RequiredParameter('extType', Parameter::TYPE_STRING, 'LC__ADDON__API__PARAMETER__EXTERNAL_EXT_TYPE', fn ($e) => is_string($e) && strlen($e) > 0),
            new RequiredParameter('extId', Parameter::TYPE_STRING, 'LC__ADDON__API__PARAMETER__EXTERNAL_EXT_ID', fn ($e) => is_string($e) && strlen($e) > 0),
            new RequiredParameter('title', Parameter::TYPE_STRING, 'LC__ADDON__API__PARAMETER__EXTERNAL_OBJECT_TITLE', fn ($e) => is_string($e) && strlen($e) > 0),
            new RequiredParameter('class', Parameter::TYPE_STRING, 'LC__ADDON__API__PARAMETER__EXTERNAL_OBJECT_TYPE_TITLE', fn ($e) => is_string($e) && defined($e)),
            new RequiredParameter('data', Parameter::TYPE_ARRAY, 'LC__ADDON__API__PARAMETER__EXTERNAL_CATEGORY_DATA'),
        ]);
    }

    public function request(Request $request): JsonRpcResponse
    {
        try {
            $config = new Config($request->get('extType'), $request->get('extId'), $request->get('title'), $request->get('class'), $request->get('data'));
            $success = (new PushModel($config))->prepare()
                ->sync();

            CmdbLogger::instance()
                ->writeCmdbLog(defined_or_default('C__LOGBOOK_SOURCE__API_PUSH', 0));

            return new JsonRpcResponse([
                'messages' => Logger::instance()
                    ->getRecords(),
                'success'  => true
            ]);
        } catch (\Exception $e) {
            return new JsonRpcResponse(['messages' => $e->getMessage(), 'success' => false], 400);
        }
    }
}
