<?php

namespace idoit\Module\Api\Model\External;

use idoit\Component\Logger as ParentLogger;
use Monolog\Formatter\LineFormatter;
use Monolog\Handler\AbstractProcessingHandler;
use Monolog\Handler\StreamHandler;
use Monolog\Handler\TestHandler;

class Logger extends ParentLogger
{
    const RECORD_KEYS = [
        'datetime' => true,
        'message' => true,
        'level' => true
    ];

    /**
     * @var Logger
     */
    private static $loggerInstance;

    /**
     * @var TestHandler
     */
    private TestHandler $logHandler;

    /**
     * @param TestHandler $testHandler
     *
     * @return Logger
     */
    public function setLogHandler(TestHandler $testHandler): Logger
    {
        $this->logHandler = $testHandler;
        return $this;
    }

    /**
     * @return array
     */
    public function getRecords(array $keys = []): array
    {
        if (!empty($keys) && is_numeric(key($keys))) {
            $keys = array_reverse($keys);
        }

        return array_map(fn (&$item) => $item = array_intersect_key($item, $keys ?: self::RECORD_KEYS), $this->logHandler->getRecords());
    }

    /**
     * @return Logger
     */
    public static function instance(): Logger
    {

        if (!isset(self::$loggerInstance)) {
            // Use the "TestHandler" to retrieve the log records later on.
            $logHandler = (new TestHandler())->setFormatter(new LineFormatter("%message% %context%\n", null, false, true));

            self::$loggerInstance = new Logger('External.Push', [
                $logHandler
            ]);
            self::$loggerInstance->setLogHandler($logHandler);
        }

        return self::$loggerInstance;
    }
}
