<?php

namespace idoit\Module\Api\Model\External;

use idoit\Component\Helper\ArrayHelper;
use idoit\Module\Api\PushIdentifier\PushIdentifier;
use isys_api_model_cmdb;
use isys_api_model_cmdb_category;
use isys_api_model_cmdb_object;
use isys_application;

class Pull extends AbstractExternal
{
    /**
     * @return array
     * @throws \isys_exception_api
     * @throws \isys_exception_auth
     * @throws \isys_exception_database
     */
    public function get(): array
    {
        $dao = isys_application::instance()->container->get('cmdb_dao');
        $db = isys_application::instance()->container->get('database');
        $pushIdentifier = PushIdentifier::instance($db);
        $externalType = $this->config->getExtType();

        $entries = $pushIdentifier->findReferences($externalType, $this->config->getExtId());
        $data = [];
        $objectApi = new isys_api_model_cmdb_object($dao);
        $categoryApi = new isys_api_model_cmdb_category($dao);
        $objectInfo = [];

        foreach ($entries as $entry) {
            [$rootExtType, $rootExtId, $category] = explode('/', $entry['externalType']);

            $key = "{$entry['externalType']}/{$entry['externalId']}";
            if (PushIdentifier::isObjectReference($entry['referenceType'])) {
                $data["{$entry['externalType']}/{$entry['externalId']}"] = $this->getObjectOrEntry(
                    $objectApi,
                    $entry['externalType'],
                    $entry['externalId'],
                    ['objID' => (int)$entry['referenceId']]
                );
                $objectInfo[$key] = (int)$entry['referenceId'];
                continue;
            }

            if (!isset($objectInfo["{$rootExtType}/{$rootExtId}"])) {
                $objectData = current($pushIdentifier->findReferences($rootExtType, $rootExtId) ?? []);
                if (empty($objectData)) {
                    continue;
                }

                $data["{$objectData['externalType']}/{$objectData['externalId']}"] = $this->getObjectOrEntry(
                    $objectApi,
                    $objectData['externalType'],
                    $objectData['externalId'],
                    ['objID' => (int)$objectData['referenceId']]
                );
                $objectInfo["{$rootExtType}/{$rootExtId}"] = (int)$objectData['referenceId'];
            }

            if (!isset($objectInfo["{$rootExtType}/{$rootExtId}"])) {
                continue;
            }

            $data["{$rootExtType}/{$rootExtId}"]['data'][$category][] = $this->getObjectOrEntry($categoryApi, $entry['externalType'], $entry['externalId'], [
                'objID' => (int)$objectInfo["{$rootExtType}/{$rootExtId}"],
                'category' => $category,
                'entry' => (int)$entry['referenceId'] ?: null,
            ]);
        }
        return array_values($data);
    }

    /**
     * @param isys_api_model_cmdb $api
     * @param string              $extType
     * @param string              $extId
     * @param array               $data
     *
     * @return array
     * @throws \idoit\Module\Api\Exception\ValidationException
     * @throws \isys_exception_api
     * @throws \isys_exception_auth
     * @throws \isys_exception_database
     */
    private function getObjectOrEntry(isys_api_model_cmdb $api, string $extType, string $extId, array $data = [])
    {
        if ($api instanceof isys_api_model_cmdb_category) {
            $responseData = current($api->read($data) ?? []);
        } else {
            $responseData = $api->read($data);
        }

        if (!is_array($responseData)) {
            return [];
        }

        return ArrayHelper::concat(
            [
                'extId'   => $extId,
                'extType' => $extType
            ],
            $responseData
        );
    }
}
