<?php

namespace idoit\Module\Api\Model\External\Push;

use ArrayIterator;
use idoit\Module\Api\Model\External\CategoryStrategy\CategoryStrategyInterface;
use idoit\Module\Api\Model\External\Logger;
use idoit\Module\Api\Model\External\Handler\CiObject;
use isys_cmdb_dao_category;

class Category
{
    const STRATEGY_CREATE = 'create';
    const STRATEGY_UPDATE = 'update';
    const STRATEGY_OVERWRITE = 'overwrite';

    /**
     * @var isys_cmdb_dao_category
     */
    protected isys_cmdb_dao_category $dao;

    /**
     * @var CategoryStrategyInterface
     */
    protected CategoryStrategyInterface $strategy;

    /**
     * @var Entry[]
     */
    protected array $data = [];

    /**
     * @param isys_cmdb_dao_category    $dao
     * @param CategoryStrategyInterface $strategy
     */
    public function __construct(isys_cmdb_dao_category $dao, CategoryStrategyInterface $strategy)
    {
        $this->dao = $dao;
        $this->strategy = $strategy;
    }

    /**
     * @return isys_cmdb_dao_category
     */
    public function getDao(): isys_cmdb_dao_category
    {
        return $this->dao;
    }

    /**
     * @return CategoryStrategyInterface
     */
    public function getStrategy(): CategoryStrategyInterface
    {
        return $this->strategy;
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        return $this->data;
    }

    /**
     * @param array $data
     *
     * @return Category
     */
    private function setData(array $data): Category
    {
        $this->data = $data;
        return $this;
    }

    /**
     * @param array          $entries
     *
     * @return Category
     * @throws \isys_exception_dao
     * @throws \isys_exception_database
     */
    public function prepare(CiObject $ciObject, array $entries): Category
    {
        $data = [];
        $strategy = $this->getStrategy();

        $data = $strategy->prepare($this->getDao(), $ciObject, $entries);

        $this->setData($data);

        return $this;
    }
}