<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Validation\Property;

use idoit\Module\Api\Exception\ValidationException;
use idoit\Module\Api\Validation\PropertyValidation;

/**
 * Class Upload
 *
 * @package idoit\Module\Api\Validation\Property
 */
class Upload extends PropertyValidation
{

    /**
     * Validate value
     *
     * @return bool
     * @throws ValidationException
     */
    public function validate()
    {
        global $g_dirs;

        $value = $this->getValue();

        // Decode file
        $decodedFile = base64_decode($value);

        // Create intermediate image file path
        $filePath = $g_dirs["fileman"]["image_dir"] . 'tempImage-' . uniqid();

        // Create temporary image file to detect mime type
        file_put_contents($filePath, $decodedFile);

        // Check mime type
        if (mime_content_type($filePath) == 'inode/x-empty') {
            throw new ValidationException($this->getPropertyType(), 'Provided value is not a valid base64 encoded string.');
        }

        // Remove temporary file
        unlink($filePath);

        return true;
    }
}
