<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Validation;

use idoit\Component\Property\Property;
use idoit\Module\Api\Exception\ValidationException;

/**
 * Class Validation
 *
 * @package idoit\Module\Api\Validation
 */
abstract class Validation implements Validatable
{
    public static $isAssignmentCategory = false;
    /**
     * Property definition
     *
     * @var array
     */
    protected $propertyDefinition;

    /**
     * Property title
     *
     * @var string
     */
    protected $title;

    /**
     * Property value
     *
     * @var mixed
     */
    protected $value;

    /**
     * @return string
     */
    protected function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $title
     *
     * @return Validation
     */
    protected function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * @return mixed
     */
    protected function getValue()
    {
        return $this->value;
    }

    /**
     * @param mixed $value
     *
     * @return Validation
     */
    protected function setValue($value)
    {
        $this->value = $value;

        return $this;
    }

    /**
     * @return array
     */
    protected function getPropertyDefinition()
    {
        return $this->propertyDefinition;
    }

    /**
     * @param array|Property $propertyDefinition
     *
     * @return Validation
     */
    protected function setPropertyDefinition($propertyDefinition)
    {
        if (!($propertyDefinition instanceof Property) && !is_array($propertyDefinition)) {
            throw new ValidationException('The provided property definition needs to be an array or instance of Property.');
        }

        $this->propertyDefinition = $propertyDefinition;

        return $this;
    }

    /**
     * Get property type
     *
     * @return string
     */
    protected function getPropertyType()
    {
        return $this->getPropertyDefinition()[C__PROPERTY__INFO][C__PROPERTY__INFO__TYPE];
    }

    /**
     * Validation constructor.
     *
     * @param string         $title
     * @param mixed          $value
     * @param array|Property $propertyDefinition
     */
    public function __construct($title, $value, $propertyDefinition)
    {
        if (!($propertyDefinition instanceof Property) && !is_array($propertyDefinition)) {
            throw new ValidationException('The provided property definition needs to be an array or instance of Property.');
        }

        // Initialize information
        $this->setTitle($title)
            ->setValue($value)
            ->setPropertyDefinition($propertyDefinition);
    }
}
