<?php

use idoit\AddOn\AdministratableInterface;
use idoit\AddOn\AuthableInterface;
use idoit\AddOn\ExtensionProviderInterface;
use idoit\Module\Api\ApiExtension;
use idoit\Module\Api\SettingPage\ApiConfiguration;
use idoit\Module\Api\SettingPage\AttributeDocumentation;
use idoit\Module\Api\SettingPage\EndpointDefinition;

/**
 * i-doit
 *
 * API module class
 *
 * @package     Modules
 * @subpackage  API
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_api extends isys_module implements AdministratableInterface, AuthableInterface, ExtensionProviderInterface
{
    /**
     * @param isys_module_request $request
     *
     * @return $this
     */
    public function init(isys_module_request $request)
    {
        return $this;
    }

    /**
     * @param isys_component_tree $tree
     * @param int                 $addonNodeId
     *
     * @return void
     * @throws Exception
     */
    public function buildAdministrationTree(isys_component_tree $tree, int $addonNodeId): void
    {
        $auth = self::getAuth();

        $nextId = $tree->count();
        $imageDir = isys_application::instance()->www_path . 'images/axialis/';

        $apiParentNode = $tree->add_node(
            ++$nextId,
            $addonNodeId,
            'JSON-RPC API',
            isys_helper_link::create_url([
                C__GET__MODULE_ID     => C__MODULE__SYSTEM,
                C__GET__MODULE_SUB_ID => C__MODULE__API
            ]),
            null,
            self::getWwwPath() . "assets/add-on-icon.svg",
            $_GET[C__GET__MODULE_ID] == C__MODULE__SYSTEM && $_GET[C__GET__MODULE_SUB_ID] == C__MODULE__API,
            null,
            null,
            $auth->is_allowed_to(isys_auth::VIEW, 'CONFIGURATION')
        );

        $tree->add_node(
            ++$nextId,
            $apiParentNode,
            $this->language->get('LC__ADDON__API__ATTRIBUTE_DOCUMENTATION'),
            isys_helper_link::create_url([
                C__GET__MODULE_ID     => C__MODULE__SYSTEM,
                C__GET__MODULE_SUB_ID => C__MODULE__API,
                C__GET__SETTINGS_PAGE => 'attributes',
            ]),
            null,
            "{$imageDir}basic/gear.svg",
            $_GET[C__GET__MODULE_ID] == C__MODULE__SYSTEM && $_GET[C__GET__MODULE_SUB_ID] == C__MODULE__API && $_GET[C__GET__SETTINGS_PAGE] === 'attributes',
            null,
            null,
            $auth->is_allowed_to(isys_auth::VIEW, 'CATEGORIES_ATTRIBUTES')
        );

        $tree->add_node(
            ++$nextId,
            $apiParentNode,
            $this->language->get('LC__ADDON__API__ENDPOINT_DOCUMENTATION'),
            isys_helper_link::create_url([
                C__GET__MODULE_ID     => C__MODULE__SYSTEM,
                C__GET__MODULE_SUB_ID => C__MODULE__API,
                C__GET__SETTINGS_PAGE => 'endpoint-definition',
            ]),
            null,
            "{$imageDir}basic/gear.svg",
            $_GET[C__GET__MODULE_ID] == C__MODULE__SYSTEM && $_GET[C__GET__MODULE_SUB_ID] == C__MODULE__API && $_GET[C__GET__SETTINGS_PAGE] === 'endpoint-definition',
            null,
            null,
            $auth->is_allowed_to(isys_auth::VIEW, 'CATEGORIES_ATTRIBUTES')
        );
    }

    public function start()
    {
        $navMode = (int)($_POST[C__GET__NAVMODE] ?: $_GET[C__GET__NAVMODE]);

        $template = isys_application::instance()->container->get('template');
        $database = isys_application::instance()->container->get('database');
        $language = isys_application::instance()->container->get('language');

        switch ($_GET[C__GET__SETTINGS_PAGE]) {
            case 'attributes':
                (new AttributeDocumentation($template, $database, $language))->renderPage($navMode);
                return;

            case 'endpoint-definition':
                (new EndpointDefinition($template, $database, $language))->renderPage($navMode);
                return;

            default:
                (new ApiConfiguration($template, $database, $language))->renderPage($navMode);
                return;
        }
    }

    /**
     * @return isys_auth|isys_auth_analytics
     */
    public static function getAuth()
    {
        return isys_auth_api::instance();
    }

    /**
     * @return ApiExtension
     */
    public function getContainerExtension()
    {
        return new ApiExtension();
    }
}
