<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

use idoit\Console\Command\Search\IndexerCommand;
use idoit\Console\Command\Search\SearchCommand;

/**
 * Class isys_model_console_search
 */
class isys_api_model_console_search extends isys_api_model_console
{
    /**
     * Search for CIs
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function query(array $params = [])
    {
        // Check whether command exists
        $this->commandExists(SearchCommand::class);

        return $this->run(SearchCommand::NAME, $params['options'], $params['arguments']);
    }

    /**
     * Search for CIs
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function index(array $params = [])
    {
        // Check whether command exists
        $this->commandExists(IndexerCommand::class);

        return $this->run(IndexerCommand::NAME, $params['options'], $params['arguments']);
    }
}