<?php

namespace idoit\Module\Api\Controller;

use isys_helper_link;
use idoit\Module\Api\Category\Descriptor;
use idoit\Module\Api\PushIdentifier\PushIdentifier;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * PushIdentifierController
 */
class PushIdentifierController
{
    /**
     * @param Request $request
     *
     * @return Response
     * @throws \isys_exception_cmdb
     */
    public function index(Request $request): Response
    {
        $type = $request->get('externalType');
        $id = $request->get('externalId');
        $exception = new \Exception("External identifier for type '{$type}' and id '{$id}' does not exist. Please check 'externalType' and 'externalId' and try again.");

        if (!is_string($type) || !is_string($id)) {
            http_response_code(404);
            throw $exception;
        }

        $pushIdentifier = new PushIdentifier(\isys_application::instance()->container->get('database'));
        $results = $pushIdentifier->findReferences($request->get('externalType'), $request->get('externalId'));

        if (!count($results)) {
            http_response_code(404);
            throw $exception;
        }

        $result = reset($results);
        if (PushIdentifier::isObjectReference($result['referenceType'])) {
            return new RedirectResponse("/index.php?objID={$result['referenceId']}");
        }
        $descriptor = Descriptor::byConstant($result['referenceType']);
        $objectId = $descriptor->getDaoInstance()->get_data_by_id($result['referenceId'])
            ->get_row_value("{$descriptor->getFullSourceTable()}__isys_obj__id");

        $queryParams = [
            C__CMDB__GET__OBJECT => $objectId,
            C__CMDB__GET__CATG => $descriptor->isGlobal() ? $descriptor->getId() : null,
            C__CMDB__GET__CATS => $descriptor->isSpecific() ? $descriptor->getId() : null,
            C__CMDB__GET__CATG_CUSTOM => $descriptor->isCustom() ? $descriptor->getId() : null,
            C__CMDB__GET__CATLEVEL => $descriptor->isMultivalue() ? $result['referenceId'] : null
        ];

        if ($descriptor->isGlobal()) {
            $url = isys_helper_link::create_catg_item_url($queryParams, true);
        } elseif ($descriptor->isSpecific()) {
            $url = isys_helper_link::create_cats_item_url($queryParams, true);
        } else {
            $url = isys_helper_link::create_catg_custom_item_url($queryParams, true);
        }

        return new RedirectResponse($url);
    }
}
