<?php

namespace idoit\Module\Api\Endpoint\v2\Cmdb;

use idoit\Api\EndpointInterface;
use idoit\Module\Api\Exception\JsonRpc\InternalErrorException;
use isys_application;
use isys_cmdb_dao;
use isys_component_dao_lock;
use isys_component_database;

abstract class AbstractCmdbEndpoint implements EndpointInterface
{
    protected isys_component_database $database;

    protected isys_component_dao_lock $daoLock;

    protected isys_cmdb_dao $daoCmdb;

    public function __construct()
    {
        $this->database = isys_application::instance()->container->get('database');
        $this->daoCmdb = isys_application::instance()->container->get('cmdb_dao');
        $this->daoLock = isys_component_dao_lock::instance($this->database);
    }

    protected function lockObject(int $objectId): void
    {
        if ($this->daoLock->is_locked($objectId)) {
            $lockInformation = $this->daoLock->get_lock_information($objectId)
                ->get_row();

            $lockedBy = $this->daoCmdb->get_obj_name_by_id_as_string($lockInformation['isys_user_session__isys_obj__id']);
            $remainingSeconds = (C__LOCK__TIMEOUT - (time() - strtotime($lockInformation['isys_lock__datetime'])));

            throw new InternalErrorException("The object is currently locked by user '{$lockedBy}' for at least {$remainingSeconds} seconds.");
        }

        $this->daoLock->add_lock($objectId);
    }

    protected function unlockObject(int $objectId): void
    {
        $this->daoLock->delete_by_object_id($objectId);
    }
}
