<?php

namespace idoit\Module\Api\Endpoint\v2\Cmdb\External;

use idoit\Api\EndpointDefinition;
use idoit\Api\JsonRpcResponse;
use idoit\Api\Parameter\OptionalParameter;
use idoit\Api\Parameter\Parameter;
use idoit\Api\Parameter\RequiredParameter;
use idoit\Module\Api\Category\Entry;
use idoit\Module\Api\Endpoint\v2\Cmdb\AbstractCmdbEndpoint;
use idoit\Module\Api\Exception\JsonRpc\AuthenticationException;
use idoit\Module\Api\Exception\JsonRpc\InternalErrorException;
use idoit\Module\Api\Model\External\Config;
use idoit\Module\Api\Model\External\Pull as PullModel;
use isys_auth;
use isys_module_cmdb;
use Symfony\Component\HttpFoundation\Request;

/**
 * CMDB category external pull
 *
 * @see       API-484
 * @package   idoit\Api
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class Pull extends AbstractCmdbEndpoint
{
    public function getDefinition(): EndpointDefinition
    {
        return new EndpointDefinition('cmdb.external.pull.v2', 'LC__ADDON__API__ENDPOINT__CMDB_EXTERNAL_PULL', [
            new RequiredParameter('extType', Parameter::TYPE_STRING, 'LC__ADDON__API__PARAMETER__EXTERNAL_EXT_TYPE', fn ($e) => is_string($e) && strlen($e) > 0),
            new OptionalParameter('extId', Parameter::TYPE_STRING, 'LC__ADDON__API__PARAMETER__EXTERNAL_EXT_ID', fn ($e) => is_string($e) && strlen($e) > 0),
        ]);
    }

    public function request(Request $request): JsonRpcResponse
    {
        $extType = $request->get('extType');
        $extId = $request->get('extId');

        [$rootExtType, $rootExtId, $category] = explode('/', $extType);

        if (isset($extId) && !isset($rootExtId)) {
            $extType .= "/{$extId}";
            $extId = null;
        }

        $config = new Config($extType, $extId);
        return new JsonRpcResponse((new PullModel($config))->get());
    }
}
