<?php

namespace idoit\Module\Api\Endpoint\v2\System\Endpoints;

use idoit\Api\EndpointDefinition;
use idoit\Api\EndpointInterface;
use idoit\Api\JsonRpcResponse;
use idoit\Api\Parameter\OptionalParameter;
use idoit\Api\Parameter\RequiredParameter;
use idoit\Module\Api\Endpoint\Helper;
use isys_application;
use Symfony\Component\HttpFoundation\Request;

class Read implements EndpointInterface
{
    public function getDefinition(): EndpointDefinition
    {
        return new EndpointDefinition('system.endpoints.read.v2', 'LC__ADDON__API__ENDPOINT__SYSTEM_ENDPOINTS_READ', [], [
            'Basic request' => Helper::exampleRequest('system.endpoints.read.v2')
        ], [
            'Basic response' => Helper::exampleResponse([

                'cmdb.category.archive.v2' => [
                    'description' => 'Will "archive" a singular category entry.',
                    'parameters'  => [
                        'required' => [
                            'object'   => [
                                'types'          => [
                                    'integer'
                                ],
                                'description'    => 'Numeric object ID.',
                                'has-validation' => true
                            ],
                            'category' => [
                                'types'          => [
                                    'string'
                                ],
                                'description'    => 'Category constant as string.',
                                'has-validation' => true
                            ],
                            'entry'    => [
                                'types'          => [
                                    'integer'
                                ],
                                'description'    => 'Numeric entry ID.',
                                'has-validation' => true
                            ]
                        ],
                        'optional' => []
                    ]
                ],
                'cmdb.category.delete.v2'  => [
                    'description' => 'Will "delete" a singular category entry.',
                    'parameters'  => [
                        'required' => [
                            'object'   => [
                                'types'          => [
                                    'integer'
                                ],
                                'description'    => 'Numeric object ID.',
                                'has-validation' => true
                            ],
                            'category' => [
                                'types'          => [
                                    'string'
                                ],
                                'description'    => 'Category constant as string.',
                                'has-validation' => true
                            ],
                            'entry'    => [
                                'types'          => [
                                    'integer'
                                ],
                                'description'    => 'Numeric entry ID.',
                                'has-validation' => true
                            ]
                        ],
                        'optional' => []
                    ]
                ],
                'cmdb.category.purge.v2'   => ['...'],
                '...'   => [],
            ])
        ]);
    }

    public function request(Request $request): JsonRpcResponse
    {
        $language = isys_application::instance()->container->get('language');

        $responseData = [];

        // Fetch all endpoints.
        $endpoints = isys_application::instance()->container->get('api.endpoints')
            ->all();

        foreach ($endpoints as $name => $endpoint) {
            /** @var EndpointInterface $endpoint */

            $parameters = [
                'required' => [],
                'optional' => [],
            ];

            foreach ($endpoint->getDefinition()->getRequiredParameters() as $parameter) {
                /** @var RequiredParameter $parameter */
                $parameters['required'][$parameter->getName()] = [
                    'types'          => $parameter->getTypes(),
                    'description'    => $language->get($parameter->getDescription()),
                    'has-validation' => $parameter->getValidation() !== null
                ];
            }

            foreach ($endpoint->getDefinition()->getOptionalParameters() as $parameter) {
                /** @var OptionalParameter $parameter */
                $parameters['optional'][$parameter->getName()] = [
                    'types'          => $parameter->getTypes(),
                    'description'    => $language->get($parameter->getDescription()),
                    'has-validation' => $parameter->getValidation() !== null,
                    'default-value'  => $parameter->getDefaultValue()
                ];
            }

            $responseData[$name] = array_filter([
                'description'     => $language->get($endpoint->getDefinition()->getDescription()),
                'parameters'      => $parameters,
                'example-request' => $endpoint->getDefinition()->getExampleRequest(),
                'example-response' => $endpoint->getDefinition()->getExampleResponse(),
            ]);
        }

        ksort($responseData);

        return new JsonRpcResponse($responseData);
    }
}
