<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Exception\JsonRpc;

/**
 * Class MethodException
 *
 * @package idoit\Module\Api\Exception\JsonRpc
 */
class MethodException extends AbstractJsonRpcException
{

    /**
     * Get error code
     *
     * @return int
     */
    public function getErrorCode()
    {
        return -32601;
    }

    /**
     * Get error topic
     *
     * @return string
     */
    public function getErrorTopic()
    {
        return 'Method not found';
    }
}