<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\ResponseModifier;
use isys_export_helper;

/**
 * 'Organization' Processor
 *
 * @package idoit\Module\Api\Model\Cmdb\Category\Processor
 */
class OrganizationProcessor extends AbstractCategoryProcessor implements ResponseModifier
{
    /**
     * Modify api response
     *
     * @param array $response
     *
     * @return array
     */
    public function modifyResponse(array $response)
    {
        // Get request.
        $request = $this->getRequest();

        // Check whether api request is 'read' and response object has results
        if (\is_array($request) && (!isset($request['raw']) || !$request['raw']) && $request['option'] === 'read' && \is_array($response) && \count($response)) {
            foreach ($response as &$responseItem) {
                $organizationData = $this->dao->get_data(null, $request['object'])->get_row();

                // @see API-464 Fill the 'headquarter' properly.
                if ($organizationData['isys_connection__isys_obj__id']) {
                    $responseItem['headquarter'] = (new isys_export_helper($organizationData, $this->dao->get_database_component()))
                        ->object($organizationData['isys_connection__isys_obj__id']);
                }
            }
        }

        return array_values($response);
    }
}
