<?php

namespace idoit\Module\Api\Model\External\CategoryStrategy;

use idoit\Module\Api\Model\External\Logger;
use idoit\Module\Api\Model\External\Push\Entry;
use idoit\Module\Api\Model\External\Handler\Category;
use idoit\Module\Api\Model\External\Handler\CiObject;
use idoit\Module\Cmdb\Component\SyncMerger\Config;
use idoit\Module\Cmdb\Component\SyncMerger\Merger;
use isys_application;
use isys_cmdb_dao_category;
use isys_import_handler_cmdb;

class Overwrite extends Update implements CategoryStrategyInterface
{
    protected const STRATEGY = 'overwrite';

    /**
     * @param isys_cmdb_dao_category $dao
     * @param array                  $entries
     *
     * @return array
     */
    protected function prepareMultivalue(isys_cmdb_dao_category $dao, CiObject $ciObject, array $entries): array
    {
        $data = [];
        $externalType = "{$ciObject->getExtType()}/{$ciObject->getExtId()}/{$dao->get_category_const()}";
        $categoryEntry = new Category($ciObject, $dao, $externalType, $dao->get_category_const());
        $existingExternalIds = $categoryEntry->find();
        $logger = Logger::instance();

        foreach ($entries as $externalId => $entry) {
            $created = false;
            if (($refId = array_search($externalId, $existingExternalIds)) === false) {
                $refId = $categoryEntry->create();
                $categoryEntry->createIdentifier($externalId, $refId);
                $logger->info("New category entry {$refId} created for custom id {$externalId}.");
                $created = true;
            } else {
                unset($existingExternalIds[$refId]);
                $logger->info("Overwriting category entry {$refId} data for custom id {$externalId}.");
            }

            $data[] = $categoryEntry->buildEntry($refId, $entry, $created);
        }

        if (!empty($existingExternalIds)) {
            foreach ($existingExternalIds as $categoryEntryId => $externalId) {
                $logger->info("Removing category entry {$categoryEntryId} data and custom id {$externalId} reference.");
            }

            $categoryEntry->deleteByExternalIds($existingExternalIds);
            $categoryEntry->deleteCategoryEntriesByIds(array_keys($existingExternalIds));
        }

        return $data;
    }
}