<?php

namespace idoit\Module\Api\Model\External;

use idoit\Module\Api\Model\External\CategoryStrategy\CategoryStrategyInterface;
use idoit\Module\Api\Model\External\CategoryStrategy\Create;
use idoit\Module\Api\Model\External\CategoryStrategy\Overwrite;
use idoit\Module\Api\Model\External\CategoryStrategy\Update;
use idoit\Module\Api\Model\External\Exception\StrategyException;
use idoit\Module\Api\Model\External\Push\Category;

class CategoryStrategyProvider
{
    /**
     * @var array<CategoryStrategyInterface>
     */
    protected $strategies = [];

    public function __construct() {
        $this->strategies = [
            new Create(),
            new Update(),
            new Overwrite()
        ];
    }

    /**
     * @param string $strategy
     *
     * @return CategoryStrategyInterface
     * @throws StrategyException
     */
    public function getStrategy(string $strategy)
    {
        foreach ($this->strategies as $strategyComponent) {
            if (!$strategyComponent->isApplicable($strategy)) {
                continue;
            }
            return $strategyComponent;
        }

        throw new StrategyException("Strategy {$strategy} could not be found.");
    }
}