<?php

namespace idoit\Module\Api\Model\External;

class Config
{
    /**
     * @var string
     */
    protected string $extType;

    /**
     * @var string|null
     */
    protected ?string $extId = null;

    /**
     * @var string|null
     */
    protected ?string $title = null;

    /**
     * @var string|null
     */
    protected ?string $class = null;

    /**
     * @var array
     */
    protected array $data = [];

    /**
     * @var int
     */
    protected int $objectId;

    /**
     * @param string      $extType
     * @param string|null $extId
     * @param string|null $title
     * @param string|null $class
     * @param array|null  $data
     */
    public function __construct(string $extType, ?string $extId = null, ?string $title = null, ?string $class = null, ?array $data = [])
    {
        $this->extId = $extId;
        $this->extType = $extType;
        $this->title = $title;
        $this->class = $class;
        $this->data = $data ?? [];
    }

    /**
     * @return string|null
     */
    public function getExtId(): ?string
    {
        return $this->extId;
    }

    /**
     * @return string
     */
    public function getExtType(): string
    {
        return $this->extType;
    }

    /**
     * @return string|null
     */
    public function getTitle(): ?string
    {
        return $this->title;
    }

    /**
     * @return string|null
     */
    public function getClass(): ?string
    {
        return $this->class;
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        return $this->data;
    }

    /**
     * @return int
     */
    public function getObjectId(): int
    {
        return $this->objectId;
    }

    /**
     * @param int $objectId
     */
    public function setObjectId(int $objectId): void
    {
        $this->objectId = $objectId;
    }
}
