<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.com>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Property;

use isys_cmdb_dao_category;

/**
 * Class PropertyReadEntityDefinition
 *
 * @package idoit\Module\Api\Property
 */
class PropertyReadEntityDefinition
{

    public static function dialog()
    {
        return new PropertyReadEntity('Dialog entity', 'object', [
            'id'         => '(string) Id of dialog value',
            'title'      => '(string) Translated title of dialog',
            'const'      => '(string|null) Constant of dialog',
            'title_lang' => '(string) Language constant of dialog'
        ], [
            'id'         => '1',
            'title'      => 'In Betrieb',
            'const'      => 'C__DIALOG_CONSTANT__IN_OPERATION',
            'title_lang' => 'LC__DIALOG_ENTRY__IN_OPERATION'
        ]);
    }

    public static function object()
    {
        return new PropertyReadEntity('Object entity', 'object', [
            'id'         => '(string) Id of cmdb object',
            'title'      => '(string) Translated title of cmdb object',
            'sysid'      => '(string) SysID of cmdb object',
            'type'       => '(string) Constant of cmdb object',
            'type_title' => '(string) Language constant of cmdb object type'
        ], [
            'id'         => '100',
            'title'      => 'CMDB Object #100',
            'sysid'      => 'SYSID_1280838789',
            'type'       => 'C__OBJTYPE__SERVER',
            'type_title' => 'LC__CMDB__OBJTYPE__SERVER'
        ]);
    }

    public static function location()
    {
        return new PropertyReadEntity('Location entity', 'object', [
            'id'            => '(string) Id of cmdb object',
            'title'         => '(string) Translated title of cmdb object',
            'sysid'         => '(string) SysID of cmdb object',
            'type'          => '(string) Constant of cmdb object',
            'type_title'    => '(string) Language constant of cmdb object type',
            'location_path' => '(string) Location path of cmdb object'
        ], [
            'id'            => '100',
            'title'         => 'CMDB Object #100',
            'sysid'         => 'SYSID_1280838789',
            'type'          => 'C__OBJTYPE__SERVER',
            'type_title'    => 'LC__CMDB__OBJTYPE__SERVER',
            'location_path' => 'Germany > Nordrhein-Westfalen > Düsseldorf > Building A > Room 100'
        ]);
    }

    public static function connection()
    {
        return new PropertyReadEntity('Connected object entity', 'object', [
            'id'            => '(string) Id of cmdb object',
            'title'         => '(string) Translated title of cmdb object',
            'sysid'         => '(string) SysID of cmdb object',
            'type'          => '(string) Constant of cmdb object',
            'type_title'    => '(string) Language constant of cmdb object type',
            'connection_id' => '(string) Id of connection between cmdb objects'
        ], [
            'id'            => '100',
            'title'         => 'CMDB Object #100',
            'sysid'         => 'SYSID_1280838789',
            'type'          => 'C__OBJTYPE__SERVER',
            'type_title'    => 'LC__CMDB__OBJTYPE__SERVER',
            'connection_id' => '50'
        ]);
    }

    public static function timestamp()
    {
        return new PropertyReadEntity('Timestamp entity', 'object', [
            'id'    => '(string) Timestamp value',
            'title' => '(string) ISO 8601 representation of timestamp',
        ], [
            'id'    => '1534144237',
            'title' => '2018-08-13T09:10:37+02:00',
        ]);
    }

    public static function object_image()
    {
        return new PropertyReadEntity('Object image entity', 'object', [
            'file_name' => '(string) Filename of image',
            'title'     => '(string) String value representing a base64 encoded file',
            'url'     => '(string) Relative URL to the object image',
            'absolute_url'     => '(string) Absolute URL to the object image',
        ], [
            'file_name' => 'cmdb_object_image.jpg',
            'title'     => '__BASE_64_ENCODED_FILE__',
            'url'     => '/idoit/cmdb/object/image/1234',
            'absolute_url'     => 'https://i-doit-host.int/idoit/cmdb/object/image/1234',
        ]);
    }

    public static function dialog_plus()
    {
        return new PropertyReadEntity('Dialog plus entity', 'object', [
            'id'         => '(string) Id of dialog value',
            'title'      => '(string) Translated title of dialog',
            'const'      => '(string|null) Constant of dialog',
            'title_lang' => '(string) Language constant of dialog'
        ], [
            'id'         => '1',
            'title'      => 'In Betrieb',
            'const'      => 'C__DIALOG_CONSTANT__IN_OPERATION',
            'title_lang' => 'LC__DIALOG_ENTRY__IN_OPERATION'
        ]);
    }

    public static function model_title()
    {
        return new PropertyReadEntity('Model title entity', 'object', [
            'id'         => '(string) Id of dialog value',
            'title'      => '(string) Translated title of dialog',
            'const'      => '(string|null) Constant of dialog',
            'title_lang' => '(string) Language constant of dialog'
        ], [
            'id'         => '1',
            'title'      => 'In Betrieb',
            'const'      => 'C__DIALOG_CONSTANT__IN_OPERATION',
            'title_lang' => 'LC__DIALOG_ENTRY__IN_OPERATION'
        ]);
    }

    public static function contact()
    {
        /**
         * @todo
         */
    }

    public static function export_contact()
    {
        /**
         * @todo
         */
    }

    public static function convert()
    {
        return new PropertyReadEntity('Converted entity', 'object', [
            'title' => '(integer|float|double) Converted value'
        ], [
            'title' => '2000'
        ]);
    }

    public static function money_format()
    {
        return new PropertyReadEntity('Money entity', 'integer|string', null, 2000);
    }

    public static function routing_gateway()
    {
        /**
         * @todo Please check this again.
         */
        return new PropertyReadEntity('Gateway entity', 'object[]', [
            'id'       => '(string) Id of ip entry',
            'title'    => '(string) Ip address of entry',
            'hostname' => '(string) Hostname of entry',
            'type'     => '(string) Category constant of source'
        ], [
            'id'       => '1',
            'title'    => '192.168.0.100',
            'hostname' => 'idoit.cmdb.object.test',
            'type'     => 'C__CATG__IP'
        ]);
    }

    public static function hostaddress()
    {
        return new PropertyReadEntity('Hostaddress entity', 'object[]', [
            'id'       => '(string) Id of ip entry',
            'title'    => '(string) Ip address of entry',
            'hostname' => '(string) Hostname of entry',
            'type'     => '(string) Category constant of source'
        ], [
            'id'       => '1',
            'title'    => '192.168.0.100',
            'hostname' => 'idoit.cmdb.object.test',
            'type'     => 'C__CATG__IP'
        ]);
    }

    public static function ports()
    {
        return new PropertyReadEntity('Port entity', 'object[]', [
            'id'    => '(string) Id of port entry',
            'title' => '(string) Title of port entry',
            'type'  => '(string) Category constant of source'
        ], [
            'id'    => '1',
            'title' => 'Port A',
            'type'  => 'C__CATG__NETWORK_PORT'
        ]);
    }

    public static function portgroups()
    {
        return new PropertyReadEntity('Port group entity', 'object[]', [
            'id'     => '(string) Id of port group',
            'vlanid' => '(string) VlanId of port group',
            'title'  => '(string) Title of port group',
        ], [
            'id'     => '1',
            'vlanid' => 'portgroup.vlanid.abc',
            'title'  => 'Portgroup ABC'
        ]);
    }

    public static function serviceconsoleports()
    {
        return new PropertyReadEntity('Service console port entity', 'object[]', [
            'id'     => '(string) Id of service console port entry',
            'title'  => '(string) Title of service console port entry',
            'ref_id' => '(string) Id of assigned ip entry',
            'ip'     => '(string) Ip address presentation of assigned ip',
            'type'   => '(string) Category constant of source',
        ], [
            'id'     => '1',
            'title'  => 'Serice Console Port 1',
            'ref_id' => '100',
            'ip'     => '192.168.0.100',
            'type'   => 'C__CATG__IP',
        ]);
    }

    public static function vmkernelports()
    {
        return new PropertyReadEntity('VM kernel port entity', 'object[]', [
            'id'     => '(string) Id of VM kernel port entry',
            'title'  => '(string) Title of VM kernel port entry',
            'ref_id' => '(string) Id of assigned ip entry',
            'ip'     => '(string) Ip address presentation of assigned ip',
            'type'   => '(string) Category constant of source',
        ], [
            'id'     => '1',
            'title'  => 'VM kernel Port 1',
            'ref_id' => '100',
            'ip'     => '192.168.0.100',
            'type'   => 'C__CATG__IP',
        ]);
    }

    public static function interface_p()
    {
        return new PropertyReadEntity('Interface entity', 'object', [
            'id'           => '(string) Id of interface entry',
            'title'        => '(string) Title of interface entry',
            'serial'       => '(string) Serial of interface entry',
            'slot'         => '(string) Slot number of interface entry',
            'manufacturer' => '(string) Manufacturer of interface entry',
            'model'        => '(string) Model of interface entry',
            'type'         => '(string) Category constant of source',
        ], [
            'id'           => '1',
            'title'        => 'Interface 1',
            'serial'       => '0101010101010101',
            'slot'         => '0101010101010101',
            'manufacturer' => 'Manufacturer 1',
            'model'        => 'Model 1',
            'type'         => 'C__CATG__NETWORK_INTERFACE',
        ]);
    }

    public static function fc_san()
    {
        return new PropertyReadEntity('FC-San entity', 'object[]', [
            'id'            => '(string) Id of cmdb object',
            'type'          => '(string) Constant of cmdb object type',
            'sysid'         => '(string) SysId of cmdb object',
            'title'         => '(string) Title of cmdb object',
            /**
             * @todo port and wwn: Needs some investigation
             */
            'port_selected' => '(string) Selected fc port',
            'wwn_selected'  => '(string) Selected wwn port',
        ], []);
    }

    public static function connector_sibling()
    {
        return new PropertyReadEntity('Connector sibling entity', 'object', [
            'id'           => '(string) Id of connector entry',
            'title'        => '(string) Title of connector entry',
            'input_output' => '(string) Type of connector: 1: Input or 2: Output',
            'con_type'     => '(string) Type of connection',
            'type'         => '(string) Category type of connector entry'
        ], [
            'id'           => '1',
            'title'        => 'Connector 1',
            'input_output' => '1',
            'con_type'     => '@todo',
            'type'         => '@todo'
        ]);
    }

    public static function connector()
    {
        return new PropertyReadEntity('Connector entity', 'object', [
            'id'                 => '(string) Id of connector entry',
            'title'              => '(string) Title of connector entry',
            'connection_type'    => '(string) Type of connector: 1: Input or 2: Output',
            'con_type'           => '(string) Connection type of connector',
            'sibling_id'         => '(string) EntryId of sibling connector',
            'cable_connection'   => '(string) Id of cable connection',
            'assigned_connector' => '(string) Id of connected connector',
            'cable_id'           => '(string) Id of used cmdb cable object',
            'type'               => '@todo'
        ], [
            'id'                 => '1',
            'title'              => 'Connector 1',
            'connection_type'    => '1',
            'con_type'           => 'RJ-11',
            'sibling_id'         => '2',
            'cable_connection'   => '50',
            'assigned_connector' => '10',
            'cable_id'           => '20',
            'type'               => '@todo'
        ]);
    }

    public static function ui_connector()
    {
        return new PropertyReadEntity('UI connector entity', 'object[]', [
            'id'    => '(string) Id of connector entry',
            'title' => '(string) Title of connector entry',
            'type'  => '(string) Category constant of source',
        ], [
            'id'    => '1',
            'title' => 'Connector 1',
            'type'  => 'C__CATG__CONNECTOR'
        ]);
    }

    public static function psupplier_connector()
    {
        return new PropertyReadEntity('Power supplier entity', 'object[]', [
            'id'    => '(string) Id of power supplier entry',
            'title' => '(string) Title of power supplier entry',
            'type'  => '(string) Category constant of source',
        ], [
            'id'    => '1',
            'title' => 'Power supplier 1',
            'type'  => 'C__CATG__POWER_SUPPLIER'
        ]);
    }

    public static function cable_connection()
    {
        return new PropertyReadEntity('Cable connection entity', 'object', [
            'id'       => '(string) Id of cmdb cable object',
            'title'    => '(string) Title of cmdb cable object',
            'cable_id' => '(string) Id of cable connection entry',
            'sysid'    => '(string) SysId of cmdb cable object',
            'type'     => '(string) Type constant of cmdb cable object',
        ], [
            'id'       => '100',
            'title'    => 'Cable 1',
            'cable_id' => '50',
            'sysid'    => 'SYSID_1280838789',
            'type'     => 'C__OBJTYPE__CABLE',
        ]);
    }

    public static function assigned_connector()
    {
        return new PropertyReadEntity('Assigned connector entity', 'object', [
            'connector_type'    => '(string) Type of connector: 1: Input or 2: Output',
            'name'              => '(string) Title of assigned connector entry',
            'id'                => '(string) Id of cmdb object that owns assigned connector',
            'title'             => '(string) Id of cmdb object that owns assigned connector',
            'sysid'             => '(string) SysId of cmdb object that owns assigned connector',
            'type'              => '(string) Type constant of cmdb object that owns assigned connector',
            'assigned_category' => '(string) Constant of referenced category, for example "C__CATG__POWER_CONSUMER"',
            'con_type'          => '(title) Type of assigned connector entry',
        ], [
            'connector_type'    => '1',
            'name'              => 'Connector 1',
            'id'                => '100',
            'title'             => 'Cmdb object 1',
            'sysid'             => 'SYSID_1280838789',
            'type'              => 'C__OBJTYPE__SERVER',
            'assigned_category' => '@todo',
            'con_type'          => 'RJ-45'
        ]);
    }

    public static function ui()
    {
        return new PropertyReadEntity('Universal interface entity', 'object', [
            'id'          => '(string) Id of universal interface',
            'title'       => '(string) Title of universal interface cmdb object',
            'sysid'       => '(string) SysId of universal interface cmdb object',
            'type'        => '(string) Type constant of universal interface cmdb object',
            'ref_id'      => '(string) Id of universal interface entry',
            'ref_title'   => '(string) Title of universal interface entry',
            'ref_type'    => 'Category constant of source',
            'ui_con_type' => 'Connectiont type of universal interface',
        ], [
            'id'          => '100',
            'title'       => 'Universal Interface VM 1',
            'sysid'       => 'SYSID_1280838789',
            'type'        => 'C__OBJTYPE__SERVER',
            'ref_id'      => '10',
            'ref_title'   => '@todo',
            'ref_type'    => '@todo',
            'ui_con_type' => '@todo'
        ]);
    }

    public static function port()
    {
        return new PropertyReadEntity('Port entity', 'object', [
            'id'              => '(string) Id of cmdb object owning the given port',
            'title'           => '(string) Title of cmdb object owning the given port',
            'sysid'           => '(string) SysId of cmdb object owning the given port',
            'type'            => '(string) Type constant of cmdb object owning the given port',
            'type_title'      => '(string) Type title of cmdb object owning the given port',
            'ref_id'          => '(string) Id of port entry',
            'ref_title'       => '(string) Title of port entry',
            'ref_type'        => '(string) Category constant of source',
            'mac'             => '(string) MAC of port entry',
            'interface'       => self::interface_p(),
            'enabled'         => '(string) Indicates whether port is enabled/disabled',
            /**
             * @todo
             */
            'number'          => '(string) Number of port entry',
            'port_speed'      => '(string) Speed of port entry',
            'port_speed_unit' => self::dialog_plus(),
            'port_type'       => self::dialog_plus(),
            'plug_type'       => self::dialog_plus(),
            'port_duplex'     => self::dialog_plus(),
            'standard'        => self::dialog_plus(),
            'negotiation'     => self::dialog_plus(),
            'description'     => '(text) Description of port entry',
        ], []);
    }

    public static function logical_port()
    {
        return new PropertyReadEntity('Logical port entity', 'object', [
            'id'         => '(string) Id of cmdb object owning the logical port',
            'title'      => '(string) Title of cmdb object owning the logical port',
            'sysid'      => '(string) SysId of cmdb object owning the logical port',
            'type'       => '(string) Type constant of cmdb object owning the logical port',
            'type_title' => '(string) Type title of cmdb object owning the logical port',
            'ref_id'     => '(string) Id of logical port entry',
            'ref_title'  => '(string) Title of logical port entry',
            'ref_type'   => '(string) Category constant of source',
            'mac'        => '(string) MAC of logical port entry',
        ], [
            'id'         => '1',
            'title'      => 'Cmdb Object 1',
            'sysid'      => 'SYSID_1280838789',
            'type'       => 'C__OBJTYPE__SERVER',
            'type_title' => 'Server',
            'ref_id'     => '100',
            'ref_title'  => 'Logical port 1',
            'ref_type'   => 'C__CATG__NETWORK_LOG_PORT',
            'mac'        => '01010101010101'
        ]);
    }

    public static function storage_device()
    {
        return new PropertyReadEntity('Storage device entity', 'object', [
            'id'                     => '(string) Id of cmdb object owning the storage device',
            'title'                  => '(string) Title of cmdb object owning the storage device',
            'sysid'                  => '(string) SysId of cmdb object owning the storage device',
            'type'                   => '(string) Type constant of cmdb object owning the storage device',
            'type_title'             => '(string) Type title of cmdb object owning the storage device',
            'ref_id'                 => '(string) Id of storage device entry',
            'ref_title'              => '(string) Title of storage device entry',
            'ref_type'               => '(string) Category constant of source',
            'stor_device_type_id'    => '(string) Id of storage device type',
            'stor_device_type_const' => '(string) Constant of storage device type',
            'stor_device_type_title' => '(string) Title of storage device type'
        ], [
            'id'                     => '1',
            'title'                  => 'Cmdb Object 1',
            'sysid'                  => 'SYSID_1280838789',
            'type'                   => 'C__OBJTYPE__SERVER',
            'type_title'             => 'Server',
            'ref_id'                 => '100',
            'ref_title'              => 'Storage device 1',
            'ref_type'               => 'C__CATG__STORAGE_DEVICE',
            'stor_device_type_id'    => '1',
            'stor_device_type_const' => 'C__STOR_TYPE_DEVICE_HD',
            'stor_device_type_title' => 'LC__STORAGE_TYPE__HARD_DISK'
        ]);
    }

    public static function guest_systems()
    {
        return self::object();
    }

    public static function storage_raid()
    {
        return new PropertyReadEntity('Storage raid entity', 'object', [
            'id'    => '(string) Id of storage raid entry',
            'title' => '(string) Title of device name',
        ], [/**
         * todo
         */
        ]);
    }

    public static function storage_ldev()
    {
        return new PropertyReadEntity('LDEV storage entity', 'object', [
            'id'        => '(string) Id of cmdb object owning the storage',
            'title'     => '(string) Title of of cmdb object owning the storage',
            'sysid'     => '(string) SysId of cmdb object owning the storage',
            'type'      => '(string) Type constant of cmdb object owning the storage',
            'ref_id'    => '(string) Id of ldev storage entry',
            'ref_title' => '(string) Title of ldev storage entry',
            'ref_type'  => 'Category constant of source',
        ], [
            'id'        => '1',
            'title'     => 'Cmdb Object 1',
            'sysid'     => 'SYSID_1280838789',
            'type'      => 'C__OBJTYPE__SERVER',
            'ref_id'    => '100',
            'ref_title' => 'Ldev Storage 1',
            'ref_type'  => 'C__CATG__LDEV_CLIENT'
        ]);
    }

    public static function storage_drive()
    {
        return new PropertyReadEntity('Drive storage entity', 'object', [
            'id'        => '(string) Id of cmdb object owning the storage',
            'title'     => '(string) Title of of cmdb object owning the storage',
            'sysid'     => '(string) SysId of cmdb object owning the storage',
            'type'      => '(string) Type constant of cmdb object owning the storage',
            'ref_id'    => '(string) Id of drive entry',
            'ref_title' => '(string) Title of drive entry',
            'ref_type'  => 'Category constant of source',
        ], [
            'id'        => '1',
            'title'     => 'Cmdb Object 1',
            'sysid'     => 'SYSID_1280838789',
            'type'      => 'C__OBJTYPE__SERVER',
            'ref_id'    => '100',
            'ref_title' => 'Drive Storage 1',
            'ref_type'  => 'C__CATG__DRIVE'
        ]);
    }

    public static function ldevclient_ldevserver()
    {
        return new PropertyReadEntity('Drive storage entity', 'object', [
            'id'        => '(string) Id of cmdb object',
            'title'     => '(string) Title of of cmdb object',
            'sysid'     => '(string) SysId of cmdb object',
            'type'      => '(string) Type constant of cmdb object',
            'ref_id'    => '(string) Id of entry',
            'ref_title' => '(string) Title of entry',
            'ref_type'  => 'Category constant of source',
        ], [
            'id'        => '1',
            'title'     => 'Cmdb Object 1',
            'sysid'     => 'SYSID_1280838789',
            'type'      => 'C__OBJTYPE__SERVER',
            'ref_id'    => '100',
            'ref_title' => 'Sanpool 1',
            'ref_type'  => 'C__CATG__LDEV_SERVER'
        ]);
    }

    public static function ldevclient_hba()
    {
        return new PropertyReadEntity('HBA entity', 'object', [
            'id'    => '(string) Id of HBA entry',
            'title' => '(string) Title of HBA entry',
        ], [
            'id'    => '1',
            'title' => 'HBA1',
        ]);
    }

    public static function ldevclient_assigned_path()
    {
        return new PropertyReadEntity('Assigned path entity', 'object[]', [
            'id'      => '(string) Id of fc port entry',
            'title'   => '(string) Title of fc port entry',
            'wwn'     => '(string) WWN of fc port entry',
            'wwpn'    => '(string) WWPN of fc port entry',
            'type'    => '(string) Category constant of source',
            'primary' => '(string) Indicator whether fc port is primary or not',
        ], [
            'id'      => '100',
            'title'   => 'FC-Port 1',
            'wwn'     => '010101',
            'wwpn'    => '010101',
            'type'    => 'C__CATG__CONTROLLER_FC_PORT',
            'primary' => '1',
        ]);
    }

    public static function ldev_paths()
    {
        return new PropertyReadEntity('Ldev path entity', 'object[]', [
            'id'      => '(string) Id of fc port entry',
            'title'   => '(string) Title of fc port entry',
            'type'    => '(string) Category constant of source',
            'primary' => '(string) Indicator whether fc port is primary or not'
        ], [
            'id'      => '1',
            'title'   => 'FC Port 1',
            'type'    => 'C__CATG__CONTROLLER_FC_PORT',
            'primary' => '1',
        ]);
    }

    public static function ldev_connected_devices()
    {
        return new PropertyReadEntity('Connected device entity', 'object[]', [
            'id'    => '(string) Id of raid/storage entry',
            'title' => '(string) Title of raid/storage entry',
            'type'  => '(string) Category constant of source',
        ], [
            'id'    => '100',
            'title' => 'Raid 1',
            'type'  => 'C__CATG__STORAGE_DEVICE',
        ]);
    }

    public static function ldevclient_connected_clients()
    {
        return new PropertyReadEntity('Connected ldev clients entity', 'object', [
            'id'        => '(string) Id of cmdb object',
            'title'     => '(string) Title of of cmdb object',
            'sysid'     => '(string) SysId of cmdb object',
            'type'      => '(string) Type constant of cmdb object',
            'ref_id'    => '(string) Id of entry',
            'ref_title' => '(string) Title of entry',
            'ref_type'  => 'Category constant of source',
        ], [
            'id'        => '1',
            'title'     => 'Cmdb Object 1',
            'sysid'     => 'SYSID_1280838789',
            'type'      => 'C__OBJTYPE__SERVER',
            'ref_id'    => '100',
            'ref_title' => 'LDEV client 1',
            'ref_type'  => 'C__CATG__LDEV_CLIENT'
        ]);
    }

    public static function chassis_devices()
    {
        /**
         * @todo
         */
        return new PropertyReadEntity('Chassis device entity', 'object[]', '', []);
    }

    public static function chassis_slots()
    {
        /**
         * @todo
         */
        return new PropertyReadEntity('Chassis slot entity', 'object[]', '', []);
    }

    public static function logiface_ports()
    {
        return new PropertyReadEntity('Port entity', 'object[]', [
            'id'    => '(string) Id of port entry',
            'title' => '(string) Title of port entry',
            'type'  => '(string) Category constant of source',
        ], [
            'id'    => '1',
            'title' => 'Port 1',
            'type'  => 'C__CATG__NETWORK_PORT'
        ]);
    }

    public static function raid()
    {
        return new PropertyReadEntity('Raid member entity', 'object[]', [
            'id'       => '(string) Id of drive entry',
            'title'    => '(string) Title of drive entry',
            'capacity' => '(string) Capacity of drive entry',
            'type'     => '(string) Category constant of source',
        ], [
            'id'    => '1',
            'title' => 'Port 1',
            'type'  => 'C__CATG__NETWORK_PORT'
        ]);
    }

    public static function raid_capacity()
    {
        return new PropertyReadEntity('Raid capactiy entity', 'object', [
            'title' => '(string) Capacity of raid',
        ], [
            'title' => '30000'
        ]);
    }

    public static function cluster_hostaddress()
    {
        return self::hostaddress();
    }

    public static function cluster_drives()
    {
        return new PropertyReadEntity('Drive entity', 'object[]', [
            'id'    => '(string) Id of drive entry',
            'title' => '(string) Title of drive entry',
            'type'  => '(string) Category constant of source',
        ], [
            'id'    => '1',
            'title' => 'Drive 1',
            'type'  => 'C__CATG__CLUSTER_SERVICE'
        ]);
    }

    public static function cluster_shares()
    {
        return new PropertyReadEntity('Share entity', 'object[]', [
            'id'    => '(string) Id of share entry',
            'title' => '(string) Title of share entry',
            'type'  => '(string) Category constant of source',
        ], [
            'id'    => '1',
            'title' => 'Share 1',
            'type'  => 'C__CATG__SHARES'
        ]);
    }

    public static function cluster_runs_on()
    {
        return new PropertyReadEntity('Cluster member entity', 'object[]', [
            'id'    => '(string) Id of cluster member entry',
            'title' => '(string) Title of cluster member object',
            'type'  => '(string) Category constant of source',
        ], [
            'id'    => '1',
            'title' => 'Cluster Member 1',
            'type'  => 'C__CATG__CLUSTER_MEMBERS'
        ]);
    }

    public static function cluster_administration_service()
    {
        return new PropertyReadEntity('Relation entity', 'object[]', [
            'id'    => '(string) Id of cmdb object',
            'title' => '(string) Title of cmdb object',
            'sysid' => '(string) SysId of cmdb object',
            'type'  => '(string) Type constant of cmdb object',
        ], [
            'id'    => '10',
            'title' => 'Relation #10',
            'sysid' => 'SYSID_1280838789',
            'type'  => 'C__OBJTYPE__RELATION'
        ]);
    }

    public static function soa_stack_object()
    {
        return new PropertyReadEntity('Soa stack object entity', 'object', [
            'id'    => '(string) Id of cmdb object',
            'title' => '(string) Title of cmdb object',
            'sysid' => '(string) SysId of cmdb object',
            'type'  => '(string) Type constant of cmdb object',
        ], [
            'id'    => '10',
            'title' => 'Soa stack #10',
            'sysid' => 'SYSID_1280838789',
            'type'  => 'C__OBJTYPE__SERVER'
        ]);
    }

    public static function soa_stack_components()
    {
        return new PropertyReadEntity('Cluster member entity', 'object[]', [
            'id'    => '(string) Id of application entry',
            'title' => '(string) Title of cmdb object assigned to the application',
            'type'  => '(string) Category constant of source',
        ], [
            'id'    => '1',
            'title' => 'Cmdb object #100',
            'type'  => 'C__CATG__APPLICATION'
        ]);
    }

    public static function soa_stack_it_services()
    {
        return new PropertyReadEntity('IT service object entity', 'object[]', [
            'id'    => '(string) Id of cmdb object',
            'title' => '(string) Title of cmdb object',
            'sysid' => '(string) SysId of cmdb object',
            'type'  => '(string) Type constant of cmdb object',
        ], [
            'id'    => '10',
            'title' => 'IT service #10',
            'sysid' => 'SYSID_1280838789',
            'type'  => 'C__OBJTYPE__IT_SERVICE'
        ]);
    }

    public static function get_guarantee_status()
    {
        /**
         * @todo
         */
    }

    public static function get_yes_or_no()
    {
        return new PropertyReadEntity('Yes/No entity', 'object', [
            'title' => '(string) Translated representation of yes or no',
        ], [
            'title' => 'Yes',
        ]);
    }

    public static function obj_type()
    {
        return new PropertyReadEntity('Object type string', 'string', null, 'Server');
    }

    public static function get_san_zoning_members()
    {
        return new PropertyReadEntity('SAN zone member entity', 'object[]', [
            'id'           => '(string) Id of san zone cmdb object',
            'title'        => '(string) Title of san zone cmdb object',
            'sysid'        => '(string) SysId of san zone cmdb object',
            'type_title'   => '(string) Translated title of san zone cmdb object',
            'type'         => '(string) Type constant of san zone cmdb object',
            'ref_id'       => '(string) Id of san zone member`s fc port entry',
            'ref_title'    => '(string) Title of san zone member`s fc port entry',
            'ref_type'     => '(string) Category constant of source',
            'wwn_selected' => '(string) Indicates whether wwn is selected',
        ], [
            'id'           => '100',
            'title'        => 'San zone member 20',
            'sysid'        => 'SYSID_1280838789',
            'type'         => 'C__OBJTYPE__SERVER',
            'ref_id'       => '10',
            'ref_title'    => 'FC-Port 1',
            'ref_type'     => 'C__CATG__CONTROLLER_FC_PORT',
            'wwn_selected' => '1'
        ]);
    }

    public static function file_objects()
    {
        return new PropertyReadEntity('File object entity', 'object[]', [
            'id'       => '(string) Id of cmdb object',
            'title'    => '(string) Title of cmdb object',
            'sysid'    => '(string) SysId of cmdb object',
            'type'     => '(string) Type constant of cmdb object',
            'category' => '(string) Category constant of source (C__CATG__MANUAL|C__CATG__FILE|C__CATG__EMERGENCY_PLAN)'
        ], [
            'id'       => '10',
            'title'    => 'File object #10',
            'sysid'    => 'SYSID_1280838789',
            'type'     => 'C__OBJTYPE__FILE',
            'category' => 'C__CATG__EMERGENCY_PLAN'
        ]);
    }

    public static function file_version()
    {
        return new PropertyReadEntity('File version entity', 'object', [
            'file_name' => '(string) Filename of image',
            'title'     => '(string) Full path of image in filesystem',
            'value'     => '(string) Base64 encoded representation of file'
        ], [
            'file_name' => 'file_xy.pdf',
            'title'     => '/var/www/html/upload/images/cmdb_object_image.jpg',
            'value'     => '__BASE_64_ENCODED_FILE__',
        ]);
    }

    public static function get_connector_assigned_category()
    {
        return new PropertyReadEntity('Category entity', 'object', [
            'const' => '(string) Constant of category',
            'title' => '(string) Translated representation of category title',
            'value' => '(string) Id of category'
        ], [
            'const' => 'C__CATG__GLOBAL',
            'title' => 'General',
            'value' => '1',
        ]);
    }

    public static function cluster_service_connection()
    {
        return new PropertyReadEntity('Cluster member entity', 'object', [
            'id'    => '(string) Id of cluster member entry id',
            'title' => '(string) Title of cmdb object assigned as cluster member',
            'type'  => '(string) Category constant of source'
        ], [
            'id'    => '1',
            'title' => 'Cluster member cmdb object #10',
            'type'  => 'C__CATG__CLUSTER_MEMBERS',
        ]);
    }

    public static function get_reference_value()
    {
        return new PropertyReadEntity('Reference value entity', 'object', 'Reference value', []);
    }

    public static function relation_connection()
    {
        return new PropertyReadEntity('Relation master and slave entity', 'object[]', [
            'id'    => '(string) Id of master/slave cmdb object',
            'title' => '(string) Title of master/slave cmdb object',
            'sysid' => '(string) SysId of master/slave cmdb object',
            'type'  => '(string) Type constant of master/slave cmdb object',
        ], [
            [
                'id'    => '100',
                'title' => 'Master cmdb object 100',
                'sysid' => 'SYSID_1280838100',
                'type'  => 'C__OBJTYPE__SERVER',
            ],
            [
                'id'    => '200',
                'title' => 'Slave cmdb object 200',
                'sysid' => 'SYSID_1280838200',
                'type'  => 'C__OBJTYPE__APPLICATION',
            ]
        ]);
    }

    public static function relation_direction()
    {
        return new PropertyReadEntity('Relation master entity', 'object', [
            'id'    => '(string) Id of cmdb object',
            'title' => '(string) Title of cmdb object',
            'sysid' => '(string) SysId of cmdb object',
            'type'  => '(string) Type constant of cmdb object',
        ], [
            'id'    => '10',
            'title' => 'Relation master #10',
            'sysid' => 'SYSID_1280838710',
            'type'  => 'C__OBJTYPE__CLIENT'
        ]);
    }

    public static function get_vm_host()
    {
        return new PropertyReadEntity('VM host entity', 'object', [
            'id'    => '(string) Id of vm host entry id',
            'title' => '(string) Title of vm host cmdb object',
            'type'  => '(string) Category constant of source'
        ], [
            'id'    => '1',
            'title' => 'VM host',
            'type'  => 'C__CATG__VIRTUAL_MACHINE',
        ]);
    }

    public static function relation_object()
    {
        return self::relation_connection();
    }

    public static function virtual_device_port_group()
    {
        return new PropertyReadEntity('Port group entity', 'object[]', [
            'id'                   => '(string) Id of vm object',
            'title'                => '(string) Title of vm object',
            'sysid'                => '(string) SysId of vm object',
            'type'                 => '(string) Type constant of vm object',
            'ref_id'               => '(string) Id of port group entry',
            'ref_title'            => '(string) Title of port group entry',
            'ref_type'             => '(string) Category constant of source',
            'vs_port_group_title'  => '(string) Title of port group entry',
            'vs_port_group_vlanid' => '(string) VlanId of port group entry',
        ], [
            'id'                   => '100',
            'title'                => 'Virtual machine 20',
            'sysid'                => 'SYSID_1280838789',
            'type'                 => 'C__OBJTYPE__VIRTUAL_MACHINE',
            'ref_id'               => '10',
            'ref_title'            => 'Virtual switch 1',
            'ref_type'             => 'C__CATG__VIRTUAL_SWITCH',
            'vs_port_group_title'  => 'Port group 1',
            'vs_port_group_vlanid' => 'Port group vlanid 1'
        ]);
    }

    public static function physical_file()
    {
        return new PropertyReadEntity('Physical file entity', 'object', [
            'file_name' => '(string) Name of file',
            'title'     => '(string) Base64 encoded representation of file wrapped in <![CDATA[',
        ], [
            'file_name' => 'file_xy.pdf',
            'title'     => '<![CDATA[__BASE_64_ENCODED_FILE__]]>',
        ]);
    }

    public static function dialog_multiselect()
    {
        return new PropertyReadEntity('Multiselect dialog entity', 'object[]', [
            'id'    => '(string) Id of dialog entry',
            'title' => '(string) Title of dialog entry',
        ], [
            [
                'id'    => '1',
                'title' => 'Dialog 1',
            ],
            [
                'id'    => '2',
                'title' => 'Dialog 2',
            ]
        ]);
    }

    public static function timeperiod()
    {
        return new PropertyReadEntity('Time period entity', 'string', '', '3 month');
    }

    public static function date()
    {
        return new PropertyReadEntity('Date entity', 'string', '', '2018-01-01');
    }

    public static function datetime()
    {
        return new PropertyReadEntity('DateTime entity', 'string', '', '2018-01-01 12:00:00');
    }

    public static function ip_helper_addresses()
    {
        return new PropertyReadEntity('IP helper entity', 'object[]', [
            'id'         => '(string) Id of ip helper entity',
            'title'      => '(string) Empty string',
            'type_title' => '(string) Title of ip helper type',
            'ip'         => '(string) Ip of helper'
        ], [
            'id'         => '1',
            'title'      => '',
            'type_title' => 'Manual',
            'ip'         => '10.10.10.2'
        ]);
    }

    public static function layer_3_assignment()
    {
        return new PropertyReadEntity('Layer 3 entity', 'object[]', [
            'id'         => '(string) Id of layer 3 cmdb object',
            'title'      => '(string) Title of layer 3 cmdb object',
            'type_title' => '(string) Title of layer 3 cmdb object',
        ], [
            'id'         => '1',
            'title'      => 'Layer-3 10',
            'type_title' => 'Layer-3 10',
        ]);
    }

    public static function log_port_assigned_ips()
    {
        return new PropertyReadEntity('Port entity', 'object[]', [
            'id'       => '(string) Id of ip entry id',
            'title'    => '(string) Title of ip address entry',
            'hostname' => '(string) Hostname of assigned ip entry',
            'obj_id'   => '(string) Id of cmdb object owning the logical port',
            'type'     => '(string) Category constant of source'
        ], [
            'id'       => '1',
            'title'    => 'Net ip address',
            'hostname' => 'hostname.local',
            'obj_id'   => '10',
            'type'     => 'C__CATG__IP',
        ]);
    }

    public static function layer3_net_ip()
    {
        return new PropertyReadEntity('Ip assignment entity', 'object', [
            'id'       => '(string) Id of cmdb object',
            'title'    => '(string) Title of cmdb object',
            'hostname' => '(string) Hostname of cmdb object',
            'sysid'    => '(string) SysId of cmdb object',
            'type'     => '(string) Translated representation of cmdb object`s type'
        ], [
            'id'       => '1',
            'title'    => 'Net ip address',
            'hostname' => 'hostname.local',
            'obj_id'   => '10',
            'type'     => 'C__CATG__IP',
        ]);
    }

    public static function log_port()
    {
        return new PropertyReadEntity('Layer-2 entity', 'object[]', [
            'id'    => '(string) Id of cmdb object',
            'title' => '(string) Title of cmdb object',
            'sysid' => '(string) SysId of cmdb object',
            'type'  => '(string) Type constant of cmdb object',
        ], [
            'id'    => '10',
            'title' => 'Layer-2 #10',
            'sysid' => 'SYSID_1280838710',
            'type'  => 'C__OBJTYPE__LAYER_2_NET'
        ]);
    }

    public static function logicalPortAssignedConnection()
    {
        return new PropertyReadEntity('Object entity', 'object', [
            'id'           => '(string) Id of cmdb object',
            'title'        => '(string) Translated title of cmdb object',
            'sysid'        => '(string) SysId of cmdb object',
            'type'         => '(string) Constant of cmdb object',
            'type_title'   => '(string) Translated title of cmdb object type',
            'logPortId'    => '(string) Id of logical port entry',
            'logPortTitle' => '(string) Title of logical port entry',

        ], [
            'id'           => '100',
            'title'        => 'CMDB Object #100',
            'sysid'        => 'SYSID_1280838789',
            'type'         => 'C__OBJTYPE__SERVER',
            'type_title'   => 'Server',
            'logPortId'    => '1',
            'logPortTitle' => 'Logical port 1'
        ]);
    }

    public static function port_assigned_layer2_nets()
    {
        return new PropertyReadEntity('Net entity', 'object[]', self::object()
            ->getDefinition(), self::object()
            ->getExample());
    }

    public static function database_instance()
    {
        /**
         * @todo
         */
    }

    public static function logbook_changes()
    {
        return new PropertyReadEntity('Logbook entity', 'string', '', 'Object #100 created.');
    }

    public static function contract_property_next_contract_end_date()
    {
        return new PropertyReadEntity('Contract end date', 'string', '', '2020-01-01');
    }

    public static function contract_property_next_notice_end_date()
    {
        return new PropertyReadEntity('Contract next notice date', 'string', '', '2020-01-01');
    }

    public static function token_property_assigned_objects()
    {
        return new PropertyReadEntity('Token entity', 'object[]', [
            'id'    => '(string) Id of cmdb object',
            'title' => '(string) Title of cmdb object',
            'type'  => '(string) Type constant of cmdb object',
            'sysid' => '(string) SysId of cmdb object',
        ], [
            'id'    => '1',
            'title' => 'Cmdb object 1',
            'type'  => 'C__OBJTYPE__SERVER',
            'sysid' => 'SYSID_123987478'
        ]);
    }

    public static function fc_port_property_controller()
    {
        return new PropertyReadEntity('FC port controller entity', 'object', [
            'id'    => '(string) Id of hba entry',
            'title' => '(string) Title of hba entry',
            'type'  => '(string) Category constant of source'
        ], [
            'id'    => '1',
            'title' => 'HBA 1',
            'type'  => 'C__CATG__HBA',
        ]);
    }

    public static function access_property_formatted_url()
    {
        return new PropertyReadEntity('Access url entity', 'string', '', 'http://www.some-http-service.com');
    }

    public static function location_property_pos()
    {
        return new PropertyReadEntity('Position entity', 'object', [
            'title'         => '(int) Technical position in rack (independend of the rack sorting)',
            'obj_id'        => '(string) Id of cmdb object',
            'visually_from' => '(int) Start position in rack (depending on the rack sorting)',
            'visually_to'   => '(int) End position in rack (depending on the rack sorting)',
        ], [
            'title'         => 8,
            'obj_id'        => '2',
            'visually_from' => 16,
            'visually_to'   => 17
        ]);
    }

    public static function property_callback_gps()
    {
        return new PropertyReadEntity('GPS entity', 'object', [
            0           => '(string) Latitude',
            1           => '(string) Longitude',
            'latitude'  => '(string) Latitude',
            'longitude' => '(string) Longitude'
        ], [
            0           => '51.2101898',
            1           => '6.7841649',
            'latitude'  => '51.2101898',
            'longitude' => '6.7841649',
        ]);
    }

    public static function property_callback_latitude()
    {
        return new PropertyReadEntity('Latitude value', 'string', '', '12993.00');
    }

    public static function property_callback_longitude()
    {
        return new PropertyReadEntity('Longitude value', 'string', '', '12993.00');
    }

    public static function get_referenced_object_and_category()
    {
        return new PropertyReadEntity('Object-category entity', 'object', [
            'id'          => '(string) Id of cmdb object',
            'title'       => '(string) Translated title of cmdb object',
            'sysid'       => '(string) SysId of cmdb object',
            'type'        => '(string) Constant of cmdb object',
            'ref_id'      => '(string) Id of category entry',
            'ref_type'    => '(string) Constant of category',
            'ref_cattype' => '(string) Type constant of category',
            'ref_title'   => '(string) Title of category',
        ], [
            'id'          => '100',
            'title'       => 'Cmdb object #100',
            'sysid'       => 'SYSID_1234567890',
            'type'        => 'C__OBJTYPE__SERVER',
            'ref_id'      => '5',
            'ref_type'    => 'C__CATG__CPU',
            'ref_cattype' => 'C__CMDB__CATEGORY__TYPE_GLOBAL',
            'ref_title'   => 'CPU'
        ]);
    }

    public static function sla_property_servicetimes()
    {
        return new PropertyReadEntity('Service time value', 'string', '', '10:00 - 20:00');
    }

    public static function guest_system_property_hostname()
    {
        return new PropertyReadEntity('Guest system hostname entity', 'object', [
            'title' => '(string) Hostname of guest system entry',
            'ip'    => '(string) Ip of guest system entry',
        ], [
            'title' => 'hostname.local',
            'ip'    => '10.10.10.02',
        ]);
    }

    public static function emergency_plan_property_time_needed()
    {
        return new PropertyReadEntity('Necessary time entity', 'object', ['title' => '(string) Value representing necessary time'], [
            'title' => '4 Month'
        ]);
    }

    public static function organization_property_contact()
    {
        return self::export_contact();
    }

    public static function person_property_contact()
    {
        return self::export_contact();
    }

    public static function person_property_ldap_id()
    {
        return new PropertyReadEntity('Ldap entity', 'object', [
            'id'    => '(string) Id of ldap entry',
            'title' => '(string) Hostname of ldap server',
            'dn'    => '(string) Dn of ldap directory the user belongs to',
        ], [
            'id'    => '2',
            'title' => 'ldap.server.local',
            'dn'    => 'cn=admin,dc=ldap,dc=server,dc=local'
        ]);
    }

    public static function parallel_rel_property_rel_pool()
    {
        return new PropertyReadEntity('Relation pool entity', 'object[]', [
            'title' => '(string) Title of cmdb object',
        ], [
            'title' => 'Cmdb object #100'
        ]);
    }

    public static function virtual_dev_property_device_type()
    {
        return new PropertyReadEntity('Virtual device type entity', 'object', [
            'id'    => '(string) Id of device type (Network = 1, Storage = 2, Interface = 3)',
            'title' => '(string) Translated title of device',
        ], [
            'id'    => '1',
            'title' => 'Network'
        ]);
    }

    public static function share_access()
    {
        return new PropertyReadEntity('Share entity', 'object', [
            'id'        => '(string) Id of cmdb object',
            'title'     => '(string) Translated title of cmdb object',
            'sysid'     => '(string) SysId of cmdb object',
            'type'      => '(string) Constant of cmdb object',
            'ref_id'    => '(string) Id of share entry',
            'ref_title' => '(string) Title of share entry',
            'ref_type'  => '(string) Category constant of source',
        ], [
            'id'        => '100',
            'title'     => 'Cmdb object #100',
            'sysid'     => 'SYSID_1234567890',
            'type'      => 'C__OBJTYPE__SERVER',
            'ref_id'    => '5',
            'ref_title' => 'Share 1',
            'ref_type'  => 'C__CATG__SHARES',
        ]);
    }

    public static function network_port_property_default_vlan()
    {
        return new PropertyReadEntity('Default vlan entity', 'object', [
            'id'        => '(string) Id of cmdb object',
            'title'     => '(string) Translated title of cmdb object',
            'sysid'     => '(string) SysId of cmdb object',
            'type'      => '(string) Constant of cmdb object',
            'ref_id'    => '(string) Id of default vlan entry',
            'ref_title' => '(string) Title of default vlan entry',
            'ref_type'  => '(string) Category constant of source',
        ], [
            'id'        => '100',
            'title'     => 'Cmdb object #100',
            'sysid'     => 'SYSID_1234567890',
            'type'      => 'C__OBJTYPE__SERVER',
            'ref_id'    => '5',
            'ref_title' => 'Default vlan 1',
            'ref_type'  => 'C__CATG__NETWORK_PORT',
        ]);
    }

    public static function wan_connected_router()
    {
        return new PropertyReadEntity('Connected router entity', 'object', [
            'id'    => '(string) Id of cmdb object',
            'title' => '(string) Translated title of cmdb object',
            'sysid' => '(string) SysId of cmdb object',
            'type'  => '(string) Type constant of cmdb object',
        ], [
            'id'    => '100',
            'title' => 'Router #100',
            'sysid' => 'SYSID_1234567890',
            'type'  => 'C__OBJTYPE__ROUTER',
        ]);
    }

    public static function wan_connected_net()
    {
        return new PropertyReadEntity('Connected net entity', 'object', [
            'id'    => '(string) Id of cmdb object',
            'title' => '(string) Translated title of cmdb object',
            'sysid' => '(string) SysId of cmdb object',
            'type'  => '(string) Type constant of cmdb object',
        ], [
            'id'    => '100',
            'title' => 'Router #100',
            'sysid' => 'SYSID_1234567890',
            'type'  => 'C__OBJTYPE__NET',
        ]);
    }

    public static function net_connector_connected_listener()
    {
        return new PropertyReadEntity('Connected listener entity', 'object', [
            'id'        => '(string) Id of cmdb object',
            'title'     => '(string) Translated title of cmdb object',
            'sysid'     => '(string) SysId of cmdb object',
            'type'      => '(string) Constant of cmdb object',
            'ref_id'    => '(string) Id of connected listener entry',
            'ref_title' => '(string) Title of connected listener entry',
            'ref_type'  => '(string) Category constant of source',
        ], [
            'id'        => '100',
            'title'     => 'Cmdb object #100',
            'sysid'     => 'SYSID_1234567890',
            'type'      => 'C__OBJTYPE__SERVER',
            'ref_id'    => '5',
            'ref_title' => 'Listener 1',
            'ref_type'  => 'C__CATG__NET_LISTENER',
        ]);
    }

    public static function vrrp_member_get_logical_port()
    {
        return new PropertyReadEntity('Logical port entity', 'object', [
            'id'        => '(string) Id of cmdb object',
            'title'     => '(string) Translated title of cmdb object',
            'sysid'     => '(string) SysId of cmdb object',
            'type'      => '(string) Constant of cmdb object',
            'ref_id'    => '(string) Id of logical port entry',
            'ref_title' => '(string) Title of logical port entry',
        ], [

            'id'        => '100',
            'title'     => 'Cmdb object #100',
            'sysid'     => 'SYSID_1234567890',
            'type'      => 'C__OBJTYPE__SERVER',
            'ref_id'    => '5',
            'ref_title' => 'Logical port 1',
        ]);
    }

    public static function applicationLicence()
    {
        return new PropertyReadEntity('Licence entity', 'object', [
            'id'        => '(string) Id of cmdb object',
            'title'     => '(string) Translated title of cmdb object',
            'sysid'     => '(string) SysId of cmdb object',
            'type'      => '(string) Type constant of cmdb object',
            'ref_id'    => '(string) Id of licence entry',
            'ref_title' => '(string) Key of licence entry',
            'ref_type'  => '(string) Category constant of source',
            'lic_type'  => '(string) Licence type (Single = 1, Volumne = 2)',
            'key'       => '(string) Key of licence entry',
            'amount'    => '(integer|float) Amount of licences',
            'cost'      => '(string) Cost of licence entry',
            'start'     => '(date) Start date of licence entry',
            'expire'    => '(date) Expiration date of licence entry',
        ], [
            'id'        => '100',
            'title'     => 'Licence #100',
            'sysid'     => 'SYSID_1234567890',
            'type'      => 'C__OBJTYPE__LICENCE',
            'ref_id'    => '1',
            'ref_title' => '123-456-789',
            'ref_type'  => 'C__CATS__LICENCE',
            'lic_type'  => '2',
            'key'       => '123-456-789',
            'amount'    => '100',
            'cost'      => '120.00',
            'start'     => '2017-01-01',
            'expire'    => '2020-01-01',
        ]);
    }

    public static function applicationDatabaseSchema()
    {
        return new PropertyReadEntity('Connected database schema entity', 'object', [
            'id'    => '(string) Id of cmdb object',
            'title' => '(string) Translated title of cmdb object',
            'sysid' => '(string) SysId of cmdb object',
            'type'  => '(string) Type constant of cmdb object',
        ], [
            'id'    => '100',
            'title' => 'Database schema #100',
            'sysid' => 'SYSID_1234567890',
            'type'  => 'C__OBJTYPE__DATABASE_SCHEMA',
        ]);
    }

    public static function clusterServiceDatabaseSchema()
    {
        return self::applicationDatabaseSchema();
    }

    public static function applicationItService()
    {
        return new PropertyReadEntity('Connected IT-service entity', 'object', [
            'id'    => '(string) Id of cmdb object',
            'title' => '(string) Translated title of cmdb object',
            'sysid' => '(string) SysId of cmdb object',
            'type'  => '(string) Type constant of cmdb object',
        ], [
            'id'    => '100',
            'title' => 'Database schema #100',
            'sysid' => 'SYSID_1234567890',
            'type'  => 'C__OBJTYPE__IT_SERVICE',
        ]);
    }

    public static function applicationAssignedVariant()
    {
        return new PropertyReadEntity('Variant entity', 'object', [
            'id'        => '(string) Id of cmdb object',
            'title'     => '(string) Translated title of cmdb object',
            'sysid'     => '(string) SysId of cmdb object',
            'type'      => '(string) Constant of cmdb object',
            'ref_id'    => '(string) Id of variant entry',
            'ref_title' => '(string) Title of variant entry',
            'ref_type'  => '(string) Category constant of source',
            'variant'   => '(string) Variant of variant entry',
        ], [

            'id'        => '100',
            'title'     => 'Operating system #100',
            'sysid'     => 'SYSID_1234567890',
            'type'      => 'C__OBJTYPE__OPERATING_SYSTEM',
            'ref_id'    => '5',
            'ref_title' => 'Variant title',
            'ref_type'  => 'C__CATS__APPLICATION_VARIANT',
            'variant'   => 'Pre-Beta-Release'
        ]);
    }

    public static function applicationAssignedVersion()
    {
        return new PropertyReadEntity('Variant entity', 'object', [
            'id'          => '(string) Id of cmdb object',
            'title'       => '(string) Translated title of cmdb object',
            'sysid'       => '(string) SysId of cmdb object',
            'type'        => '(string) Constant of cmdb object',
            'ref_id'      => '(string) Id of version entry',
            'ref_title'   => '(string) Title of version entry',
            'ref_type'    => '(string) Category constant of source',
            'servicepack' => '(string) Servicepack of version entry',
            'hotfix'      => '(string) Hotfix information of version entry',
            'kernel'      => '(string) Kernel information of version entry',
        ], [

            'id'          => '100',
            'title'       => 'Operating system #100',
            'sysid'       => 'SYSID_1234567890',
            'type'        => 'C__OBJTYPE__OPERATING_SYSTEM',
            'ref_id'      => '5',
            'ref_title'   => 'v3.5',
            'ref_type'    => 'C__CATG__VERSION',
            'servicepack' => 'SP3',
            'hotfix'      => '10.22.33.99.45.29',
            'kernel'      => '1.2'
        ]);
    }

    public function chmkExportParents()
    {
        return new PropertyReadEntity('CMK parent export entity', 'object[]', [
            'id'    => '(string) Id of cmdb object',
            'title' => '(string) Translated title of cmdb object',
            'sysid' => '(string) SysId of cmdb object',
            'type'  => '(string) Type constant of cmdb object',
        ], [
            'id'    => '100',
            'title' => 'CMK parent export #100',
            'sysid' => 'SYSID_1234567890',
            'type'  => 'C__OBJTYPE__SERVER',
        ]);

    }

    public static function licence_property_overall_costs()
    {
        return new PropertyReadEntity('Overall cost entity', 'object', [
            'title' => '(integer|float) Overall cost for licence',
        ], [
            'title' => '2000.00'
        ]);
    }

    public static function licence_property_lic_not_in_use()
    {
        return new PropertyReadEntity('Free licence entity', 'object', [
            'title' => '(integer|float) Amount of free licences',
        ], [
            'title' => '10'
        ]);
    }

    public static function licence_property_used_licence()
    {
        return new PropertyReadEntity('Used licence entity', 'object', [
            'title' => '(integer|float) Amount of used licences',
        ], [
            'title' => '10'
        ]);
    }

    public static function assigned_ip_address()
    {
        return new PropertyReadEntity('Ip entity', 'object', [
            'id'    => '(string) Id of ip entry',
            'title' => '(string) Ip address',
            'type'  => '(string) Category constant of source'
        ], [
            'id'    => '1',
            'title' => '10.10.10.2',
            'type'  => 'C__CATG__IP',
        ]);
    }

    public static function check_period()
    {
        return new PropertyReadEntity('Period entity', 'object', [
            'id'    => '(string) Id of time period entity',
            'title' => '(string) Time period name',
        ], [
            'id'    => '2',
            'title' => '24x7'
        ]);
    }

    public static function notification_period()
    {
        return self::check_period();
    }

    public static function check_command()
    {
        return new PropertyReadEntity('Nagios command entity', 'object', [
            'id'    => '(string) Id of command entry',
            'title' => '(string) Title of command entry',
        ], [
            'id'    => '2',
            'title' => 'notify-host-by-email'
        ]);
    }

    public static function event_handler()
    {
        return self::check_command();
    }

    public static function host_initial_state()
    {
        return new PropertyReadEntity('Host flap detection entity', 'object', [
            'id'    => '(string) Id of host flap detection entry',
            'title' => '(string) Title of host flap detection entry',
        ], [
            'id'    => "o",
            'title' => 'up'
        ]);
    }

    public static function service_initial_state()
    {
        return new PropertyReadEntity('Service flap detection entity', 'object', [
            'id'    => '(string) Id of service flap detection entry',
            'title' => '(string) Title of service flap detection entry',
        ], [
            'id'    => "c",
            'title' => 'CRITICAL'
        ]);
    }

    public static function host_flap_detection_options()
    {
        return self::host_flap_detection_options();
    }

    public static function service_flap_detection_options()
    {
        return self::service_flap_detection_options();
    }

    public static function host_stalking_options()
    {
        return self::host_flap_detection_options();
    }

    public static function service_stalking_options()
    {
        return self::service_flap_detection_options();
    }

    public static function host_notification_options()
    {
        return self::host_flap_detection_options();
    }

    public static function service_notification_options()
    {
        return self::service_flap_detection_options();
    }

    public static function host_escalations()
    {
        return new PropertyReadEntity('Host esalation entity', 'object[]', [
            'escalation_contacts'    => self::contact(),
            'first_notification'     => '(object) Date of first notification',
            'last_notification'      => '(object Date of last notification',
            'notification_interval'  => '(string) Interval for attempts to send notifications',
            'escalation_period'      => self::dialog_plus(),
            'escalation_period_plus' => self::dialog_plus(),
            'escalation_options'     => '(object) Options of escalation'
        ], [
            'escalation_contacts'    => [
                [
                    'id'         => '10',
                    'title'      => 'maxmustermann',
                    'first_name' => 'Max',
                    'last_name'  => 'Mustermann',
                    '...'        => '...'
                ],
                [
                    'id'         => '10',
                    'title'      => 'helenemustermann',
                    'first_name' => 'Helene',
                    'last_name'  => 'Mustermann',
                    '...'        => '...'
                ]
            ],
            'first_notification'     => [
                'title' => '2018-01-01'
            ],
            'last_notification'      => '2019-01-01',
            'notification_interval'  => '',
            'escalation_period'      => self::dialog_plus()
                ->getExample(),
            'escalation_period_plus' => self::dialog_plus()
                ->getExample(),
            'escalation_options'     => []
        ]);
    }

    public static function service_escalations()
    {
        return self::host_escalations();
    }

    public static function host_template()
    {
        return new PropertyReadEntity('Host template entity', 'object', [
            'id'    => '(string) Id of cmdb object',
            'title' => '(string) Translated title of cmdb object',
            'sysid' => '(string) SysId of cmdb object',
            'type'  => '(string) Type constant of cmdb object',
        ], [
            'id'    => '100',
            'title' => 'Host template #100',
            'sysid' => 'SYSID_1234567890',
            'type'  => 'C__OBJTYPE__NAGIOS_HOST_TPL',
        ]);
    }

    public static function host_notification_commands()
    {
        return new PropertyReadEntity('Nagios notification commands entity', 'object[]', [
            'id'    => '(string) Identifier of notification command entry',
            'title' => '(string) title of notification command entry'
        ], [
            'id'    => '1',
            'title' => 'Notification command title'
        ]);
    }

    public static function clusterServiceStatus()
    {
        return new PropertyReadEntity('Cluster service entity', 'object', [
            'id'         => '(string) Id of cluster service status',
            'title'      => '(string) Title of cluster service status',
            'title_lang' => '(string) Translated title of cluster service status'
        ], [
            'id'         => 'OK',
            'title'      => 'OK',
            'title_lang' => 'Okay'
        ]);
    }

    public static function service_notification_commands()
    {
        return self::host_notification_commands();
    }

    public static function tags()
    {
        return new PropertyReadEntity('CMK cmdb tag entity', 'object[]', [
            'id'    => '(null)',
            'const' => '(string) Constant of tag',
            'val'   => '(string) Identifier of tag',
            'sel'   => '(bool) Indicates whether tag is selected or not (Default -> true)',
            'group' => '(string) Indicates the assigned group of a tag'
        ], [
            'id'    => null,
            'const' => 'TAG_CONSTANT',
            'val'   => 'tagValue1',
            'sel'   => true,
            'group' => 'tagGroup'
        ]);
    }

    public static function cmdbTags()
    {
        return self::tags();
    }

    public static function dynamicTags()
    {
        return self::tags();
    }

    /**
     * @return PropertyReadEntity
     * @see API-460 Add definition
     */
    public static function exportContactAssignment()
    {
        return new PropertyReadEntity('Contact object data', 'object', [
            'id'                  => '(number) Numeric object ID',
            'sysid'               => '(string) SYS-ID',
            'title'               => '(string) object title',
            'first_name'          => '(string) First name',
            'last_name'           => '(string) Last name',
            // 'ldap_id' => null,
            'department'          => '(string) Department',
            // 'position' => null,
            'mail'                => '(string) Primary email address',
            'phone_company'       => '(string) Phone Company',
            'phone_mobile'        => '(string) Cellphone',
            'phone_home'          => '(string) Phone Home',
            'fax'                 => '(string) Fax',
            'organization'        => '(number) Numeric object ID of the related organization',
            'organization_title'  => '(string) Title of the related organization',
            'type'                => '(string) Object type constant (for example "C__OBJTYPE__PERSON")',
            'salutation'          => '(string) Salutation',
            'academic_degree'     => '(string) Academic degree',
            'function'            => '(string) Function',
            'service_designation' => '(string) Service Designation',
            'street'              => '(string) Street',
            'city'                => '(string) City',
            'zip_code'            => '(string) Zipcode',
            'pager'               => '(string) Pager',
            'personnel_number'    => '(string) Personal number'
        ], [
            'id'            => 1234,
            'title'         => 'Max Mustermann',
            'first_name'    => 'Max',
            'last_name'     => 'Mustermann',
            'ldap_id'       => null,
            'department'    => '',
            'position'      => null,
            'mail'          => 'max.mustermann@example.com',
            'phone_company' => null,
            'phone_mobile'  => null,
            'phone_home'    => null,
            'fax'           => null,
            '...'           => '...'
        ]);
    }

    public static function exportSalution()
    {
        return new PropertyReadEntity('Salution entity', 'object', '', [
            'm' => 'Mister'
        ]);
    }

    public static function exportCustomFieldYesNoDialog()
    {
        return new PropertyReadEntity('Custom yes/no entity', 'object', [
            'title'     => '(string) Yes/No string',
            'prop_type' => '(string) Static string "yes-no"',
        ], [
            'title'     => 'Yes',
            'prop_type' => 'yes-no'
        ]);
    }

    public static function exportCustomFieldCalendar()
    {
        return new PropertyReadEntity('Custom calendar entity', 'object', [
            'title'     => '(string) Date string',
            'prop_type' => '(string) Static string "calendar"',
        ], [
            'title'     => '2018-01-01 00:00:00',
            'prop_type' => 'calendar'
        ]);
    }

    /**
     * @return PropertyReadEntity
     * @see  ID-7507  New "date + time" property
     */
    public static function exportCustomFieldCalendarWithTime()
    {
        return new PropertyReadEntity('Custom calendar entity', 'object', [
            'title'     => '(string) Date string',
            'prop_type' => '(string) Static string "calendar"',
        ], [
            'title'     => '2018-01-01 12:30:00',
            'prop_type' => 'calendar'
        ]);
    }

    public static function exportCustomFieldObject()
    {
        return self::object();
    }

    public static function exportCustomFieldDialogPlus()
    {
        return self::dialog_plus();
    }

    public static function exportIpReference()
    {
        return new PropertyReadEntity('Ip reference entity', 'object', [
            'id'        => '(string) Id of cmdb object owning the storage',
            'title'     => '(string) Title of of cmdb object owning the storage',
            'sysid'     => '(string) SysId of cmdb object owning the storage',
            'type'      => '(string) Type constant of cmdb object owning the storage',
            'ref_id'    => '(string) Id of ip entry',
            'ref_title' => '(string) Ip address',
            'ref_type'  => 'Category constant of source',
        ], [
            'id'        => '1',
            'title'     => 'Cmdb Object 1',
            'sysid'     => 'SYSID_1280838789',
            'type'      => 'C__OBJTYPE__SERVER',
            'ref_id'    => '100',
            'ref_title' => '10.10.10.2',
            'ref_type'  => 'C__CATS__NET_IP_ADDRESSES'
        ]);
    }

    public static function exportHostname()
    {
        return new PropertyReadEntity('Hostname entity', 'string', '', 'hostname.local');
    }

    public static function exportPrimaryIpReference()
    {
        return self::exportIpReference();
    }

    public static function exportHostaddressAliases()
    {
        return new PropertyReadEntity('Hostaddress alias entity', 'object[]', [
            'host'   => '(string) Hostname',
            'domain' => '(string) Domain',
        ], [
            'host'   => 'hostname',
            'domain' => 'domain.local',
        ]);
    }

    public static function password()
    {
        return new PropertyReadEntity('Password entity', 'string', '', 'mySecretPasswordHashed');
    }

    /**
     * @todo
     */
    //    public static function applicationAssignedVariant()
    //    {
    //        return new PropertyReadEntity('Variant entity', 'object', [
    //            'id'      => '(string) Id of variant entry',
    //            'title'   => '(string) Title of variant entry',
    //            'type'    => '(string) Category constant of source',
    //            'variant' => '(string) Variant of variant entry',
    //        ], [
    //            'id'      => '10',
    //            'title'   => 'Variant title',
    //            'type'    => 'C__CATS__APPLICATION_VARIANT',
    //            'variant' => 'Variant'
    //        ]);
    //    }

    public static function databaseSchema()
    {
        return new PropertyReadEntity('Host template entity', 'object', [
            'id'    => '(string) Id of cmdb object',
            'title' => '(string) Translated title of cmdb object',
            'sysid' => '(string) SysId of cmdb object',
            'type'  => '(string) Type constant of cmdb object',
        ], [
            'id'    => '100',
            'title' => 'Database schema #100',
            'sysid' => 'SYSID_1234567890',
            'type'  => 'C__OBJTYPE__DATABASE_SCHEMA',
        ]);
    }

    public static function exportGateway()
    {
        return new PropertyReadEntity('Gateway entity', 'object', [
            'id'        => '(string) Id of cmdb object owning the gateway',
            'title'     => '(string) Title of of cmdb object owning the gateway',
            'sysid'     => '(string) SysId of cmdb object owning the gateway',
            'type'      => '(string) Type constant of cmdb object owning the gateway',
            'ref_id'    => '(string) Id of ip entry',
            'ref_title' => '(string) Ip address',
            'ref_type'  => 'Category constant of source',
        ], [
            'id'        => '1',
            'title'     => 'Cmdb Object 1',
            'sysid'     => 'SYSID_1280838789',
            'type'      => 'C__OBJTYPE__SERVER',
            'ref_id'    => '100',
            'ref_title' => '10.10.10.2',
            'ref_type'  => 'C__CATG__IP'
        ]);
    }

    public static function exportDnsServer()
    {
        return self::exportGateway();
    }

    public static function exportLayer2Assignments()
    {
        return new PropertyReadEntity('Layer2 entity', 'object', [
            'id'    => '(string) Id of cmdb object',
            'title' => '(string) Translated title of cmdb object',
            'sysid' => '(string) SysId of cmdb object',
            'type'  => '(string) Type constant of cmdb object',
        ], [
            'id'    => '100',
            'title' => 'Layer2 #100',
            'sysid' => 'SYSID_1234567890',
            'type'  => 'C__OBJTYPE__LAYER2',
        ]);
    }

    /**
     * @param isys_cmdb_dao_category $categoryDaoInstance
     * @param string                 $key
     * @param mixed                  $propertyDefinition
     *
     * @return PropertyReadEntity
     */
    public static function get(isys_cmdb_dao_category $categoryDaoInstance, string $key, $propertyDefinition)
    {
        $propertyEntityDefinition = new PropertyReadEntity('Unknown Property', 'unknown', 'Unknown property', null);

        if (is_array($propertyDefinition[C__PROPERTY__FORMAT][C__PROPERTY__FORMAT__CALLBACK]) &&
            method_exists(self::class, $propertyDefinition[C__PROPERTY__FORMAT][C__PROPERTY__FORMAT__CALLBACK][1])) {
            $propertyEntityDefinitionTmp = forward_static_call_array([
                self::class,
                $propertyDefinition[C__PROPERTY__FORMAT][C__PROPERTY__FORMAT__CALLBACK][1]
            ], []);

            // Check whether retrieved property definition is of type 'PropertyReadEntity'
            if ($propertyEntityDefinitionTmp instanceof PropertyReadEntity) {
                $propertyEntityDefinition = $propertyEntityDefinitionTmp;
            }
        } else {
            switch ($propertyDefinition[C__PROPERTY__INFO][C__PROPERTY__INFO__TYPE]) {
                case C__PROPERTY__INFO__TYPE__DATE:
                    return new PropertyReadEntity('Date', 'string', 'ISO 8601 formated date string', date('Y-m-d'));

                case C__PROPERTY__INFO__TYPE__DATETIME:
                    return new PropertyReadEntity('DateTime', 'string', 'ISO 8601 formated date string', date('Y-m-d H:i:s'));

                case C__PROPERTY__INFO__TYPE__DIALOG:
                    return new PropertyReadEntity('Dialog', 'integer|string', 'Integer value referencing an dialog entry or string referencing a dialog value by title or constant', 'Exact dialog title');

                case C__PROPERTY__INFO__TYPE__DIALOG_PLUS:
                    return new PropertyReadEntity(
                        'Dialog Plus',
                        'integer|string',
                        'Integer value referencing an dialog entry or string referencing a dialog value by title or constant. String values which cannot be found will result in new dialog entries.',
                        'Exact dialog title'
                    );

                case C__PROPERTY__INFO__TYPE__DIALOG_LIST:
                    return new PropertyReadEntity(
                        'Dialog List',
                        'integer[]|string[]',
                        'Array of integers or strings. Integers has to reference existing dialog entries. String values will result in new dialog entries if they can not be found.',
                        ['List entry #1', 'List entry #2', 'List entry #3']
                    );

                case C__PROPERTY__INFO__TYPE__DOUBLE:
                    return new PropertyReadEntity('Double', 'integer|double', 'Integer or double value', 300.0);

                case C__PROPERTY__INFO__TYPE__FLOAT:
                    return new PropertyReadEntity('Float', 'integer|float', 'Integer or float value', 100.00);

                case C__PROPERTY__INFO__TYPE__INT:
                    return new PropertyReadEntity('Integer', 'integer', 'Integer value', 10);

                case C__PROPERTY__INFO__TYPE__MONEY:
                    return new PropertyReadEntity('Money', 'integer|float', 'Integer or float value', 5000.00);

                case C__PROPERTY__INFO__TYPE__MULTISELECT:
                    return new PropertyReadEntity('Multiselect', 'integer[]|string[]', 'Array of integers or strings', ['List entry #1', 'List entry #2', 'List entry #3']);

                case C__PROPERTY__INFO__TYPE__OBJECT_BROWSER:
                    if ($propertyDefinition[C__PROPERTY__UI][C__PROPERTY__UI__PARAMS]['multiselection']) {
                        return new PropertyReadEntity(
                            'Object browser (multi)',
                            'integer[]',
                            'Array of integers or strings. Integers has to reference existing dialog entries. String values will result in new dialog entries if they can not be found.',
                            [1, 2, 3, 4]
                        );
                    }

                    return new PropertyReadEntity('Object browser', 'integer', 'Integer value', 10);

                case C__PROPERTY__INFO__TYPE__TEXT:
                    return new PropertyReadEntity('Text', 'string', 'String value', 'Example text value');

                case C__PROPERTY__INFO__TYPE__TEXTAREA:
                    return new PropertyReadEntity('Text Area', 'string', 'String value', 'Example text area value');

                case C__PROPERTY__INFO__TYPE__UPLOAD:
                    return new PropertyReadEntity('Upload', 'string', 'String value representing a base64 encoded file', '__BASE_64_ENCODED_FILE__');

                case C__PROPERTY__INFO__TYPE__COMMENTARY:
                    return new PropertyReadEntity('Commentary', 'string', 'String value', 'Example commentary text');
            }
        }

        return $propertyEntityDefinition;
    }
}
